/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.common.SocketFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.objectweb.joram.client.jms.MessageInterceptor;

public class FactoryParameters
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String host;
    private int port;
    private String url;
    public boolean TcpNoDelay = true;
    public int SoLinger = -1;
    public int SoTimeout = 0;
    public int connectingTimer = 0;
    public int txPendingTimer = 0;
    public int cnxPendingTimer = 0;
    public String socketFactory = SocketFactory.DefaultFactory;
    public boolean implicitAck;
    public boolean asyncSend = false;
    public int queueMessageReadMax = 1;
    public int topicAckBufferMax = 0;
    public boolean multiThreadSync = false;
    public int multiThreadSyncDelay = 1;
    public int multiThreadSyncThreshold = 10;
    public int topicPassivationThreshold = Integer.MAX_VALUE;
    public int topicActivationThreshold = 0;
    public String outLocalAddress = null;
    public int outLocalPort = 0;
    public final List inInterceptors = new ArrayList();
    public final List outInterceptors = new ArrayList();
    private static final String INTERCEPTOR_CLASS_NAME_SEPARATOR = ",";

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUrl() {
        return this.url;
    }

    public FactoryParameters(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public FactoryParameters(String url) {
        this.url = url;
        this.host = "";
        this.port = -1;
    }

    public FactoryParameters() {
    }

    public void toReference(Reference ref, String prefix) {
        ref.add(new StringRefAddr(prefix + ".host", this.getHost()));
        ref.add(new StringRefAddr(prefix + ".port", new Integer(this.getPort()).toString()));
        ref.add(new StringRefAddr(prefix + ".url", this.getUrl()));
        ref.add(new StringRefAddr(prefix + ".TcpNoDelay", new Boolean(this.TcpNoDelay).toString()));
        ref.add(new StringRefAddr(prefix + ".SoLinger", new Integer(this.SoLinger).toString()));
        ref.add(new StringRefAddr(prefix + ".SoTimeout", new Integer(this.SoTimeout).toString()));
        ref.add(new StringRefAddr(prefix + ".cnxT", new Integer(this.connectingTimer).toString()));
        ref.add(new StringRefAddr(prefix + ".txT", new Integer(this.txPendingTimer).toString()));
        ref.add(new StringRefAddr(prefix + ".cnxPT", new Integer(this.cnxPendingTimer).toString()));
        ref.add(new StringRefAddr(prefix + ".socketFactory", this.socketFactory));
        ref.add(new StringRefAddr(prefix + ".implicitAck", new Boolean(this.implicitAck).toString()));
        ref.add(new StringRefAddr(prefix + ".asyncSend", new Boolean(this.asyncSend).toString()));
        ref.add(new StringRefAddr(prefix + ".queueMessageReadMax", new Integer(this.queueMessageReadMax).toString()));
        ref.add(new StringRefAddr(prefix + ".topicAckBufferMax", new Integer(this.topicAckBufferMax).toString()));
        ref.add(new StringRefAddr(prefix + ".multiThreadSync", new Boolean(this.multiThreadSync).toString()));
        ref.add(new StringRefAddr(prefix + ".multiThreadSyncDelay", new Integer(this.multiThreadSyncDelay).toString()));
        ref.add(new StringRefAddr(prefix + ".multiThreadSyncThreshold", new Integer(this.multiThreadSyncThreshold).toString()));
        ref.add(new StringRefAddr(prefix + ".topicPassivationThreshold", new Integer(this.topicPassivationThreshold).toString()));
        ref.add(new StringRefAddr(prefix + ".topicActivationThreshold", new Integer(this.topicActivationThreshold).toString()));
        ref.add(new StringRefAddr(prefix + ".outLocalPort", new Integer(this.outLocalPort).toString()));
        if (this.outLocalAddress != null) {
            ref.add(new StringRefAddr(prefix + ".outLocalAddress", this.outLocalAddress));
        }
        if (!this.inInterceptors.isEmpty()) {
            ref.add(new StringRefAddr(prefix + ".inInterceptors", this.getListInInterceptorClassName()));
        }
        if (this.outInterceptors != null) {
            ref.add(new StringRefAddr(prefix + ".outInterceptors", this.getListOutInterceptorClassName()));
        }
    }

    public void fromReference(Reference ref, String prefix) {
        RefAddr interceptorRef;
        this.host = (String)ref.get(prefix + ".host").getContent();
        this.port = new Integer((String)ref.get(prefix + ".port").getContent());
        this.url = (String)ref.get(prefix + ".url").getContent();
        this.TcpNoDelay = new Boolean((String)ref.get(prefix + ".TcpNoDelay").getContent());
        this.SoLinger = new Integer((String)ref.get(prefix + ".SoLinger").getContent());
        this.SoTimeout = new Integer((String)ref.get(prefix + ".SoTimeout").getContent());
        this.connectingTimer = new Integer((String)ref.get(prefix + ".cnxT").getContent());
        this.txPendingTimer = new Integer((String)ref.get(prefix + ".txT").getContent());
        this.cnxPendingTimer = new Integer((String)ref.get(prefix + ".cnxPT").getContent());
        this.socketFactory = (String)ref.get(prefix + ".socketFactory").getContent();
        this.implicitAck = new Boolean((String)ref.get(prefix + ".implicitAck").getContent());
        this.asyncSend = new Boolean((String)ref.get(prefix + ".asyncSend").getContent());
        this.queueMessageReadMax = new Integer((String)ref.get(prefix + ".queueMessageReadMax").getContent());
        this.topicAckBufferMax = new Integer((String)ref.get(prefix + ".topicAckBufferMax").getContent());
        this.multiThreadSync = new Boolean((String)ref.get(prefix + ".multiThreadSync").getContent());
        this.multiThreadSyncDelay = new Integer((String)ref.get(prefix + ".multiThreadSyncDelay").getContent());
        this.multiThreadSyncThreshold = new Integer((String)ref.get(prefix + ".multiThreadSyncThreshold").getContent());
        this.topicPassivationThreshold = new Integer((String)ref.get(prefix + ".topicPassivationThreshold").getContent());
        this.topicActivationThreshold = new Integer((String)ref.get(prefix + ".topicActivationThreshold").getContent());
        this.outLocalPort = new Integer((String)ref.get(prefix + ".outLocalPort").getContent());
        RefAddr outLocalAddressRef = ref.get(prefix + ".outLocalAddress");
        if (outLocalAddressRef != null) {
            this.outLocalAddress = (String)outLocalAddressRef.getContent();
        }
        if ((interceptorRef = ref.get(prefix + ".inInterceptors")) != null) {
            this.setListInInterceptorClassName((String)interceptorRef.getContent());
        }
        if ((interceptorRef = ref.get(prefix + ".outInterceptors")) != null) {
            this.setListOutInterceptorClassName((String)interceptorRef.getContent());
        }
    }

    public Hashtable code(Hashtable h, String prefix) {
        if (this.getHost() != null) {
            h.put(prefix + ".host", this.getHost());
        }
        h.put(prefix + ".port", new Integer(this.getPort()));
        if (this.getUrl() != null) {
            h.put(prefix + ".url", this.getUrl());
        }
        h.put(prefix + ".TcpNoDelay", new Boolean(this.TcpNoDelay));
        h.put(prefix + ".SoLinger", new Integer(this.SoLinger));
        h.put(prefix + ".SoTimeout", new Integer(this.SoTimeout));
        h.put(prefix + ".connectingTimer", new Integer(this.connectingTimer));
        h.put(prefix + ".txPendingTimer", new Integer(this.txPendingTimer));
        h.put(prefix + ".cnxPendingTimer", new Integer(this.cnxPendingTimer));
        h.put(prefix + ".socketFactory", this.socketFactory);
        h.put(prefix + ".implicitAck", new Boolean(this.implicitAck));
        h.put(prefix + ".asyncSend", new Boolean(this.asyncSend));
        h.put(prefix + ".queueMessageReadMax", new Integer(this.queueMessageReadMax));
        h.put(prefix + ".topicAckBufferMax", new Integer(this.topicAckBufferMax));
        h.put(prefix + ".multiThreadSync", new Boolean(this.multiThreadSync));
        h.put(prefix + ".multiThreadSyncDelay", new Integer(this.multiThreadSyncDelay));
        h.put(prefix + ".multiThreadSyncThreshold", new Integer(this.multiThreadSyncThreshold));
        h.put(prefix + ".topicPassivationThreshold", new Integer(this.topicPassivationThreshold));
        h.put(prefix + ".topicActivationThreshold", new Integer(this.topicActivationThreshold));
        h.put(prefix + ".outLocalPort", new Integer(this.outLocalPort));
        if (this.outLocalAddress != null) {
            h.put(prefix + ".outLocalAddress", this.outLocalAddress);
        }
        if (this.inInterceptors != null) {
            h.put(prefix + ".inInterceptors", this.getListInInterceptorClassName());
        }
        if (this.outInterceptors != null) {
            h.put(prefix + ".outInterceptors", this.getListOutInterceptorClassName());
        }
        return h;
    }

    public void decode(Hashtable h, String prefix) {
        this.host = (String)h.get(prefix + ".host");
        this.port = (Integer)h.get(prefix + ".port");
        this.url = (String)h.get(prefix + ".url");
        this.TcpNoDelay = (Boolean)h.get(prefix + ".TcpNoDelay");
        this.SoLinger = (Integer)h.get(prefix + ".SoLinger");
        this.SoTimeout = (Integer)h.get(prefix + ".SoTimeout");
        this.connectingTimer = (Integer)h.get(prefix + ".connectingTimer");
        this.txPendingTimer = (Integer)h.get(prefix + ".txPendingTimer");
        this.cnxPendingTimer = (Integer)h.get(prefix + ".cnxPendingTimer");
        this.socketFactory = (String)h.get(prefix + ".socketFactory");
        this.implicitAck = (Boolean)h.get(prefix + ".implicitAck");
        this.asyncSend = (Boolean)h.get(prefix + ".asyncSend");
        this.queueMessageReadMax = (Integer)h.get(prefix + ".queueMessageReadMax");
        this.topicAckBufferMax = (Integer)h.get(prefix + ".topicAckBufferMax");
        this.multiThreadSync = (Boolean)h.get(prefix + ".multiThreadSync");
        this.multiThreadSyncDelay = (Integer)h.get(prefix + ".multiThreadSyncDelay");
        this.multiThreadSyncThreshold = (Integer)h.get(prefix + ".multiThreadSyncThreshold");
        this.topicPassivationThreshold = (Integer)h.get(prefix + ".topicPassivationThreshold");
        this.topicActivationThreshold = (Integer)h.get(prefix + ".topicActivationThreshold");
        this.outLocalPort = (Integer)h.get(prefix + ".outLocalPort");
        this.outLocalAddress = (String)h.get(prefix + ".outLocalAddress");
        String listInterceptorClassNames = (String)h.get(prefix + ".inInterceptors");
        if (listInterceptorClassNames != null) {
            this.setListInInterceptorClassName(listInterceptorClassNames);
        }
        if ((listInterceptorClassNames = (String)h.get(prefix + ".outInterceptors")) != null) {
            this.setListOutInterceptorClassName(listInterceptorClassNames);
        }
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append('(').append(super.toString());
        strbuf.append(",host=").append(this.host);
        strbuf.append(",port=").append(this.port);
        strbuf.append(",url").append(this.url);
        strbuf.append(",connectingTimer=").append(this.connectingTimer);
        strbuf.append(",txPendingTimer=").append(this.txPendingTimer);
        strbuf.append(",cnxPendingTimer=").append(this.cnxPendingTimer);
        strbuf.append(",implicitAck=").append(this.implicitAck);
        strbuf.append(",asyncSend=").append(this.asyncSend);
        strbuf.append(",topicAckBufferMax=").append(this.topicAckBufferMax);
        strbuf.append(",multiThreadSync=").append(this.multiThreadSync);
        strbuf.append(",multiThreadSyncDelay=").append(this.multiThreadSyncDelay);
        strbuf.append(",multiThreadSyncThreshold=").append(this.multiThreadSyncThreshold);
        strbuf.append(",topicPassivationThreshold=").append(this.topicPassivationThreshold);
        strbuf.append(",topicActivationThreshold=").append(this.topicActivationThreshold);
        strbuf.append(",outLocalAddress=").append(this.outLocalAddress);
        strbuf.append(",outLocalPort=").append(this.outLocalPort);
        if (this.inInterceptors != null) {
            strbuf.append(",inInterceptors=").append(this.getListInInterceptorClassName());
        }
        if (this.outInterceptors != null) {
            strbuf.append(",outInterceptors=").append(this.getListOutInterceptorClassName());
        }
        return strbuf.toString();
    }

    public void addInInterceptor(String pInterceptorClassName) {
        this.addInterceptor(pInterceptorClassName, this.inInterceptors);
    }

    public void addOutInterceptor(String pInterceptorClassName) {
        this.addInterceptor(pInterceptorClassName, this.outInterceptors);
    }

    private void addInterceptor(String pInterceptorClassName, List pInterceptors) {
        if (pInterceptorClassName != null) {
            try {
                pInterceptors.add((MessageInterceptor)Class.forName(pInterceptorClassName).newInstance());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public boolean removeInInterceptor(String pInterceptorClassName) {
        return this.removeInterceptor(pInterceptorClassName, this.inInterceptors);
    }

    public boolean removeOutInterceptor(String pInterceptorClassName) {
        return this.removeInterceptor(pInterceptorClassName, this.outInterceptors);
    }

    public boolean removeInterceptor(String pInterceptorClassName, List pInterceptors) {
        boolean removed = false;
        if (pInterceptorClassName != null) {
            Iterator it = pInterceptors.iterator();
            while (it.hasNext()) {
                if (!pInterceptorClassName.equals(it.next().getClass())) continue;
                removed = true;
                it.remove();
            }
        }
        return removed;
    }

    private String getListInInterceptorClassName() {
        return this.getListInterceptorClassName(this.inInterceptors);
    }

    private String getListOutInterceptorClassName() {
        return this.getListInterceptorClassName(this.outInterceptors);
    }

    private String getListInterceptorClassName(List pInterceptors) {
        if (!pInterceptors.isEmpty()) {
            StringBuffer cns = new StringBuffer();
            Iterator it = pInterceptors.iterator();
            while (it.hasNext()) {
                cns.append(it.next().getClass().getName());
                if (!it.hasNext()) continue;
                cns.append(INTERCEPTOR_CLASS_NAME_SEPARATOR);
            }
            return cns.toString();
        }
        return null;
    }

    private void setListInInterceptorClassName(String pListInterceptorClassName) {
        this.setListInterceptorClassName(pListInterceptorClassName, this.inInterceptors);
    }

    private void setListOutInterceptorClassName(String pListInterceptorClassName) {
        this.setListInterceptorClassName(pListInterceptorClassName, this.outInterceptors);
    }

    private void setListInterceptorClassName(String pListInterceptorClassName, List pInterceptors) {
        if (pListInterceptorClassName != null) {
            StringTokenizer cns = new StringTokenizer(pListInterceptorClassName, INTERCEPTOR_CLASS_NAME_SEPARATOR);
            while (cns.hasMoreTokens()) {
                this.addInterceptor(cns.nextToken(), pInterceptors);
            }
        }
    }
}

