/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.common.Debug;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import org.objectweb.joram.client.jms.Connection;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.MessageConsumerListener;
import org.objectweb.joram.client.jms.Session;
import org.objectweb.joram.client.jms.SingleSessionConsumer;
import org.objectweb.joram.client.jms.TemporaryQueue;
import org.objectweb.joram.client.jms.TemporaryTopic;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.ConsumerCloseSubRequest;
import org.objectweb.joram.shared.client.ConsumerSubRequest;
import org.objectweb.joram.shared.client.ConsumerUnsubRequest;
import org.objectweb.joram.shared.excepts.SelectorException;
import org.objectweb.joram.shared.selectors.ClientSelector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class MessageConsumer
implements javax.jms.MessageConsumer {
    private static Logger logger = Debug.getLogger((String)MessageConsumer.class.getName());
    String selector;
    private boolean durableSubscriber;
    protected Destination dest;
    protected boolean noLocal;
    protected Session sess;
    String targetName;
    boolean queueMode;
    private MessageConsumerListener mcl;
    private int status;
    private Closer closer;

    MessageConsumer(Session sess, Destination dest, String selector, String subName, boolean noLocal) throws JMSException {
        Connection tempTCnx;
        Connection tempQCnx;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MessageConsumer.<init>(" + sess + ',' + dest + ',' + selector + ',' + subName + ',' + noLocal + ')'));
        }
        if (dest == null) {
            throw new InvalidDestinationException("Invalid null destination.");
        }
        dest.check();
        if (dest instanceof TemporaryQueue ? (tempQCnx = ((TemporaryQueue)dest).getCnx()) == null || !tempQCnx.equals(sess.getConnection()) : dest instanceof TemporaryTopic && ((tempTCnx = ((TemporaryTopic)dest).getCnx()) == null || !tempTCnx.equals(sess.getConnection()))) {
            throw new JMSSecurityException("Forbidden consumer on this temporary destination.");
        }
        try {
            ClientSelector.checks((String)selector);
        }
        catch (SelectorException sE) {
            throw new InvalidSelectorException("Invalid selector syntax: " + (Object)((Object)sE));
        }
        if (dest instanceof Topic) {
            if (subName == null) {
                subName = sess.getConnection().nextSubName();
                this.durableSubscriber = false;
            } else {
                this.durableSubscriber = true;
            }
            sess.syncRequest((AbstractJmsRequest)new ConsumerSubRequest(dest.getName(), subName, selector, noLocal, this.durableSubscriber, sess.isAsyncSub()));
            this.targetName = subName;
            this.noLocal = noLocal;
            this.queueMode = false;
        } else {
            this.targetName = dest.getName();
            this.queueMode = true;
        }
        this.sess = sess;
        this.dest = dest;
        this.selector = selector;
        this.closer = new Closer();
        this.setStatus(0);
    }

    MessageConsumer(Session sess, Destination dest, String selector) throws JMSException {
        this(sess, dest, selector, null, false);
    }

    private synchronized void setStatus(int status) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MessageConsumer.setStatus(" + Status.toString(status) + ')'));
        }
        this.status = status;
    }

    public final String getTargetName() {
        return this.targetName;
    }

    public final boolean getQueueMode() {
        return this.queueMode;
    }

    protected synchronized void checkClosed() throws IllegalStateException {
        if (this.status == 1) {
            throw new IllegalStateException("Forbidden call on a closed consumer.");
        }
    }

    public String toString() {
        return "Consumer:" + this.sess.getId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void setMessageListener(MessageListener messageListener) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MessageConsumer.setMessageListener(" + messageListener + ')'));
        }
        this.checkClosed();
        if (this.mcl != null) {
            if (messageListener != null) throw new IllegalStateException("Message listener not null");
            this.sess.removeMessageListener(this.mcl, true);
            this.mcl = null;
            return;
        } else {
            if (messageListener == null) return;
            this.mcl = this.sess.addMessageListener(new SingleSessionConsumer(this.queueMode, this.durableSubscriber, this.selector, this.targetName, this.sess, messageListener, this.sess.getQueueMessageReadMax(), this.sess.getTopicActivationThreshold(), this.sess.getTopicPassivationThreshold(), this.sess.getTopicAckBufferMax(), this.sess.getRequestMultiplexer()));
        }
    }

    public synchronized MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        if (this.mcl == null) {
            return null;
        }
        return this.mcl.getMessageListener();
    }

    public final String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.selector;
    }

    public Message receive(long timeOut) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MessageConsumer.receive(" + timeOut + ')'));
        }
        this.checkClosed();
        return this.sess.receive(timeOut, timeOut, this, this.targetName, this.selector, this.queueMode);
    }

    public Message receive() throws JMSException {
        return this.receive(0L);
    }

    public Message receiveNoWait() throws JMSException {
        this.checkClosed();
        if (this.sess.getConnection().isStopped()) {
            return null;
        }
        return this.sess.receive(-1L, 0L, this, this.targetName, this.selector, this.queueMode);
    }

    public void close() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"MessageConsumer.close()");
        }
        this.closer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClose() throws JMSException {
        block12: {
            MessageConsumer messageConsumer = this;
            synchronized (messageConsumer) {
                if (this.status == 1) {
                    return;
                }
                this.setStatus(1);
            }
            if (!this.queueMode) {
                if (this.durableSubscriber) {
                    try {
                        this.sess.syncRequest((AbstractJmsRequest)new ConsumerCloseSubRequest(this.targetName));
                    }
                    catch (JMSException exc) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                        }
                        break block12;
                    }
                }
                try {
                    this.sess.syncRequest((AbstractJmsRequest)new ConsumerUnsubRequest(this.targetName));
                }
                catch (JMSException exc) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) break block12;
                    logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                }
            }
        }
        this.sess.closeConsumer(this);
        if (this.mcl != null) {
            this.sess.removeMessageListener(this.mcl, false);
        }
    }

    void activateMessageInput() throws JMSException {
        if (this.mcl != null) {
            this.mcl.activateMessageInput();
        }
    }

    void passivateMessageInput() throws JMSException {
        if (this.mcl != null) {
            this.mcl.passivateMessageInput();
        }
    }

    class Closer {
        Closer() {
        }

        synchronized void close() throws JMSException {
            MessageConsumer.this.doClose();
        }
    }

    private static class Status {
        public static final int OPEN = 0;
        public static final int CLOSE = 1;
        private static final String[] names = new String[]{"OPEN", "CLOSE"};

        private Status() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }
}

