/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.objectweb.joram.client.jms.Message;
import org.objectweb.joram.client.jms.Session;

public final class StreamMessage
extends Message
implements javax.jms.StreamMessage {
    private transient ByteArrayOutputStream outputBuffer = null;
    private transient DataOutputStream outputStream = null;
    private transient DataInputStream inputStream = null;
    private transient boolean prepared = false;
    private transient int available = 0;
    private transient boolean firstTimeBytesRead = true;
    private static final int SHORT = 1;
    private static final int CHAR = 2;
    private static final int INT = 3;
    private static final int LONG = 4;
    private static final int FLOAT = 5;
    private static final int DOUBLE = 6;
    private static final int BOOLEAN = 7;
    private static final int STRING = 8;
    private static final int BYTE = 9;
    private static final int BYTES = 10;
    private static final int NULL = 11;

    StreamMessage() throws JMSException {
        this.momMsg.type = 4;
        this.outputBuffer = new ByteArrayOutputStream();
        this.outputStream = new DataOutputStream(this.outputBuffer);
        this.available = 0;
        this.firstTimeBytesRead = true;
    }

    StreamMessage(Session session, org.objectweb.joram.shared.messages.Message momMsg) throws JMSException {
        super(session, momMsg);
        try {
            this.inputStream = new DataInputStream(new ByteArrayInputStream(momMsg.body));
        }
        catch (Exception exc) {
            JMSException jE = new JMSException("Error while creating the stream facility.");
            jE.setLinkedException(exc);
            throw jE;
        }
        this.available = 0;
        this.firstTimeBytesRead = true;
    }

    @Override
    public void clearBody() throws JMSException {
        try {
            if (!this.RObody) {
                this.outputStream.close();
                this.outputBuffer.close();
            } else {
                this.inputStream.close();
            }
            this.outputBuffer = new ByteArrayOutputStream();
            this.outputStream = new DataOutputStream(this.outputBuffer);
            super.clearBody();
            this.prepared = false;
        }
        catch (IOException ioE) {
            JMSException jE = new JMSException("Error while closing the stream facilities.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
    }

    private void prepareWrite() throws JMSException {
        if (this.RObody) {
            throw new MessageNotWriteableException("Can't write a value as the message body is read-only.");
        }
        if (this.prepared) {
            this.prepared = false;
            this.outputBuffer = new ByteArrayOutputStream();
            this.outputStream = new DataOutputStream(this.outputBuffer);
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.prepareWrite();
        try {
            this.outputStream.writeByte(7);
            this.outputStream.writeBoolean(value);
        }
        catch (IOException ioE) {
            JMSException jE = new JMSException("Error while writing the value.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.prepareWrite();
        try {
            this.outputStream.writeByte(9);
            this.outputStream.writeByte(value);
        }
        catch (IOException ioE) {
            JMSException jE = new JMSException("Error while writing the value.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.writeBytes(value, 0, value.length);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.prepareWrite();
        try {
            this.outputStream.writeByte(10);
            if (value == null) {
                this.outputStream.writeInt(-1);
                return;
            }
            this.outputStream.writeInt(length);
            this.outputStream.write(value, offset, length);
        }
        catch (IOException ioE) {
            JMSException jE = new JMSException("Error while writing the value.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
    }

    public void writeChar(char value) throws JMSException {
        this.prepareWrite();
        try {
            this.outputStream.writeByte(2);
            this.outputStream.writeChar(value);
        }
        catch (IOException ioE) {
            JMSException jE = new JMSException("Error while writing the value.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.prepareWrite();
        try {
            this.outputStream.writeByte(6);
            this.outputStream.writeDouble(value);
        }
        catch (IOException ioE) {
            JMSException jE = new JMSException("Error while writing the value.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.prepareWrite();
        try {
            this.outputStream.writeByte(5);
            this.outputStream.writeFloat(value);
        }
        catch (IOException ioE) {
            JMSException jE = new JMSException("Error while writing the value.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
    }

    public void writeInt(int value) throws JMSException {
        this.prepareWrite();
        try {
            this.outputStream.writeByte(3);
            this.outputStream.writeInt(value);
        }
        catch (IOException ioE) {
            JMSException jE = new JMSException("Error while writing the value.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
    }

    public void writeLong(long value) throws JMSException {
        this.prepareWrite();
        try {
            this.outputStream.writeByte(4);
            this.outputStream.writeLong(value);
        }
        catch (IOException ioE) {
            JMSException jE = new JMSException("Error while writing the value.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
    }

    public void writeShort(short value) throws JMSException {
        this.prepareWrite();
        try {
            this.outputStream.writeByte(1);
            this.outputStream.writeShort(value);
        }
        catch (IOException ioE) {
            JMSException jE = new JMSException("Error while writing the value.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
    }

    public void writeString(String value) throws JMSException {
        this.prepareWrite();
        try {
            if (value == null) {
                this.outputStream.writeByte(11);
            } else {
                this.outputStream.writeByte(8);
                this.outputStream.writeUTF(value);
            }
        }
        catch (IOException ioE) {
            JMSException jE = new JMSException("Error while writing the value.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
    }

    public void writeObject(Object value) throws JMSException {
        this.prepareWrite();
        if (value == null) {
            try {
                this.outputStream.writeByte(11);
            }
            catch (IOException ioE) {
                JMSException jE = new JMSException("Error while writing the value.");
                jE.setLinkedException((Exception)ioE);
                throw jE;
            }
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeString((String)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException("Can't write non Java primitive type as a bytes array.");
        }
    }

    public boolean readBoolean() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            byte type = this.inputStream.readByte();
            if (type == 7) {
                return this.inputStream.readBoolean();
            }
            if (type == 8) {
                return Boolean.valueOf(this.inputStream.readUTF());
            }
            throw new MessageFormatException("type read: " + type + " is not a boolean or a String.");
        }
        catch (EOFException e1) {
            MessageEOFException exc = new MessageEOFException("end of message " + e1);
            exc.setLinkedException((Exception)e1);
            throw exc;
        }
        catch (IOException e2) {
            JMSException exc = new JMSException("IOException");
            exc.setLinkedException((Exception)e2);
            throw exc;
        }
    }

    public byte readByte() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            this.inputStream.mark(this.inputStream.available());
            byte type = this.inputStream.readByte();
            if (type == 9) {
                return this.inputStream.readByte();
            }
            if (type == 8) {
                return Byte.valueOf(this.inputStream.readUTF());
            }
            throw new MessageFormatException("type read: " + type + " is not a byte or a String.");
        }
        catch (EOFException e1) {
            MessageEOFException exc = new MessageEOFException("end of message " + e1);
            exc.setLinkedException((Exception)e1);
            throw exc;
        }
        catch (IOException e2) {
            JMSException exc = new JMSException("IOException");
            exc.setLinkedException((Exception)e2);
            throw exc;
        }
        catch (NumberFormatException e3) {
            try {
                this.inputStream.reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e3;
        }
    }

    public short readShort() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            byte type = this.inputStream.readByte();
            if (type == 1) {
                return this.inputStream.readShort();
            }
            if (type == 9) {
                return this.inputStream.readByte();
            }
            if (type == 8) {
                return Short.valueOf(this.inputStream.readUTF());
            }
            throw new MessageFormatException("type read: " + type + " is not a short, a byte or a String.");
        }
        catch (EOFException e1) {
            MessageEOFException exc = new MessageEOFException("end of message " + e1);
            exc.setLinkedException((Exception)e1);
            throw exc;
        }
        catch (IOException e2) {
            JMSException exc = new JMSException("IOException");
            exc.setLinkedException((Exception)e2);
            throw exc;
        }
    }

    public char readChar() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            byte type = this.inputStream.readByte();
            if (type == 2) {
                return this.inputStream.readChar();
            }
            if (type == 11) {
                throw new NullPointerException("null is not a char.");
            }
            throw new MessageFormatException("type read: " + type + " is not a char.");
        }
        catch (EOFException e1) {
            MessageEOFException exc = new MessageEOFException("end of message " + e1);
            exc.setLinkedException((Exception)e1);
            throw exc;
        }
        catch (IOException e2) {
            JMSException exc = new JMSException("IOException");
            exc.setLinkedException((Exception)e2);
            throw exc;
        }
    }

    public int readInt() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            byte type = this.inputStream.readByte();
            if (type == 3) {
                return this.inputStream.readInt();
            }
            if (type == 1) {
                return this.inputStream.readShort();
            }
            if (type == 9) {
                return this.inputStream.readByte();
            }
            if (type == 8) {
                return Integer.valueOf(this.inputStream.readUTF());
            }
            throw new MessageFormatException("type read: " + type + " is not a int, a short, a byte or a String.");
        }
        catch (EOFException e1) {
            MessageEOFException exc = new MessageEOFException("end of message " + e1);
            exc.setLinkedException((Exception)e1);
            throw exc;
        }
        catch (IOException e2) {
            JMSException exc = new JMSException("IOException");
            exc.setLinkedException((Exception)e2);
            throw exc;
        }
    }

    public long readLong() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            byte type = this.inputStream.readByte();
            if (type == 4) {
                return this.inputStream.readLong();
            }
            if (type == 3) {
                return this.inputStream.readInt();
            }
            if (type == 1) {
                return this.inputStream.readShort();
            }
            if (type == 9) {
                return this.inputStream.readByte();
            }
            if (type == 8) {
                return Long.valueOf(this.inputStream.readUTF());
            }
            throw new MessageFormatException("type read: " + type + " is not a int, a short, a byte or a String.");
        }
        catch (EOFException e1) {
            MessageEOFException exc = new MessageEOFException("end of message " + e1);
            exc.setLinkedException((Exception)e1);
            throw exc;
        }
        catch (IOException e2) {
            JMSException exc = new JMSException("IOException");
            exc.setLinkedException((Exception)e2);
            throw exc;
        }
    }

    public float readFloat() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            byte type = this.inputStream.readByte();
            if (type == 5) {
                return this.inputStream.readFloat();
            }
            if (type == 8) {
                return Float.valueOf(this.inputStream.readUTF()).floatValue();
            }
            throw new MessageFormatException("type read: " + type + " is not float or String.");
        }
        catch (EOFException e1) {
            MessageEOFException exc = new MessageEOFException("end of message " + e1);
            exc.setLinkedException((Exception)e1);
            throw exc;
        }
        catch (IOException e2) {
            JMSException exc = new JMSException("IOException");
            exc.setLinkedException((Exception)e2);
            throw exc;
        }
    }

    public double readDouble() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            byte type = this.inputStream.readByte();
            if (type == 6) {
                return this.inputStream.readDouble();
            }
            if (type == 5) {
                return this.inputStream.readFloat();
            }
            if (type == 8) {
                return Double.valueOf(this.inputStream.readUTF());
            }
            throw new MessageFormatException("type read: " + type + " is not a double, a float or a String.");
        }
        catch (EOFException e1) {
            MessageEOFException exc = new MessageEOFException("end of message " + e1);
            exc.setLinkedException((Exception)e1);
            throw exc;
        }
        catch (IOException e2) {
            JMSException exc = new JMSException("IOException");
            exc.setLinkedException((Exception)e2);
            throw exc;
        }
    }

    public int readBytes(byte[] bytes) throws JMSException {
        int ret;
        block17: {
            if (!this.RObody) {
                throw new MessageNotReadableException("Can't read the message body as it is write-only.");
            }
            if (bytes == null) {
                return -1;
            }
            if (bytes.length == 0) {
                return 0;
            }
            ret = 0;
            try {
                int type;
                int counter = 0;
                if (this.firstTimeBytesRead) {
                    byte type2 = this.inputStream.readByte();
                    if (type2 == 10) {
                        this.available = this.inputStream.readInt();
                        if (this.available == 0 || this.available == -1) {
                            return this.available;
                        }
                        int toread = 0;
                        toread = bytes.length >= this.available ? this.available : bytes.length;
                        for (int i = 0; i < toread; ++i) {
                            bytes[i] = this.inputStream.readByte();
                            ++counter;
                        }
                        ret = counter;
                        this.available = toread - counter;
                        this.firstTimeBytesRead = false;
                        counter = 0;
                        break block17;
                    }
                    throw new MessageFormatException("type read: " + type2 + " is not a byte[].");
                }
                if (this.available > 0) {
                    type = 10;
                } else {
                    this.inputStream.mark(this.inputStream.available());
                    type = this.inputStream.readByte();
                }
                if (type == 10) {
                    if (this.available >= 0) {
                        this.available = this.inputStream.readInt();
                    }
                    if (this.available == 0 || this.available == -1) {
                        return this.available;
                    }
                    int toread = 0;
                    toread = bytes.length >= this.available ? this.available : bytes.length;
                    for (int i = 0; i < toread; ++i) {
                        bytes[i] = this.inputStream.readByte();
                        ++counter;
                    }
                    ret = counter;
                    this.available = toread - counter;
                    this.firstTimeBytesRead = false;
                    counter = 0;
                    break block17;
                }
                this.inputStream.reset();
                this.firstTimeBytesRead = true;
                return -1;
            }
            catch (EOFException e1) {
                MessageEOFException exc = new MessageEOFException("end of message " + e1);
                exc.setLinkedException((Exception)e1);
                throw exc;
            }
            catch (IOException e2) {
                JMSException exc = new JMSException("IOException");
                exc.setLinkedException((Exception)e2);
                throw exc;
            }
        }
        if (ret == 0) {
            return -1;
        }
        return ret;
    }

    public String readString() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            byte type = this.inputStream.readByte();
            if (type == 8) {
                return this.inputStream.readUTF();
            }
            if (type == 3) {
                return String.valueOf(this.inputStream.readInt());
            }
            if (type == 1) {
                return String.valueOf(this.inputStream.readShort());
            }
            if (type == 9) {
                return String.valueOf(this.inputStream.readByte());
            }
            if (type == 5) {
                return String.valueOf(this.inputStream.readFloat());
            }
            if (type == 4) {
                return String.valueOf(this.inputStream.readLong());
            }
            if (type == 6) {
                return String.valueOf(this.inputStream.readDouble());
            }
            if (type == 7) {
                return String.valueOf(this.inputStream.readBoolean());
            }
            if (type == 2) {
                return String.valueOf(this.inputStream.readChar());
            }
            if (type == 11) {
                return null;
            }
            throw new MessageFormatException("type read: " + type + " is not a int, a short, a byte,... or a String.");
        }
        catch (EOFException e1) {
            MessageEOFException exc = new MessageEOFException("end of message " + e1);
            exc.setLinkedException((Exception)e1);
            throw exc;
        }
        catch (IOException e2) {
            JMSException exc = new JMSException("IOException");
            exc.setLinkedException((Exception)e2);
            throw exc;
        }
    }

    public Object readObject() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            byte type = this.inputStream.readByte();
            if (type == 7) {
                return new Boolean(this.inputStream.readBoolean());
            }
            if (type == 2) {
                return new Character(this.inputStream.readChar());
            }
            if (type == 9) {
                return new Byte(this.inputStream.readByte());
            }
            if (type == 1) {
                return new Short(this.inputStream.readShort());
            }
            if (type == 3) {
                return new Integer(this.inputStream.readInt());
            }
            if (type == 4) {
                return new Long(this.inputStream.readLong());
            }
            if (type == 5) {
                return new Float(this.inputStream.readFloat());
            }
            if (type == 6) {
                return new Double(this.inputStream.readDouble());
            }
            if (type == 8) {
                return this.inputStream.readUTF();
            }
            if (type == 11) {
                return null;
            }
            if (type == 10) {
                int available = this.inputStream.readInt();
                if (available == -1) {
                    return null;
                }
                if (available == 0) {
                    return new byte[0];
                }
                byte[] b = new byte[available];
                this.inputStream.read(b);
                return b;
            }
            throw new MessageFormatException("not a primitive object.");
        }
        catch (EOFException e1) {
            MessageEOFException exc = new MessageEOFException("end of message " + e1);
            exc.setLinkedException((Exception)e1);
            throw exc;
        }
        catch (IOException e2) {
            JMSException exc = new JMSException("IOException");
            exc.setLinkedException((Exception)e2);
            throw exc;
        }
    }

    public void reset() throws JMSException {
        try {
            if (!this.RObody) {
                this.outputStream.flush();
                this.momMsg.body = this.outputBuffer.toByteArray();
            } else {
                this.inputStream.close();
            }
            this.inputStream = new DataInputStream(new ByteArrayInputStream(this.momMsg.body));
            if (this.inputStream != null) {
                this.inputStream.reset();
            }
            this.RObody = true;
            this.firstTimeBytesRead = true;
        }
        catch (IOException iE) {
            JMSException jE = new JMSException("Error while manipulating the stream facilities.");
            jE.setLinkedException((Exception)iE);
            throw jE;
        }
    }

    @Override
    protected void prepare() throws JMSException {
        super.prepare();
        try {
            if (!this.RObody) {
                this.outputStream.flush();
                this.momMsg.body = this.outputBuffer.toByteArray();
                this.prepared = true;
            }
        }
        catch (IOException exc) {
            MessageFormatException jExc = new MessageFormatException("The message body could not be serialized.");
            jExc.setLinkedException((Exception)exc);
            throw jExc;
        }
    }
}

