/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.objectweb.joram.client.jms.Connection;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.TempDestDeleteRequest;
import org.objectweb.util.monolog.api.BasicLevel;

public class TemporaryQueue
extends Queue
implements javax.jms.TemporaryQueue {
    private static final long serialVersionUID = 1L;
    private Connection cnx;

    public TemporaryQueue() {
    }

    public TemporaryQueue(String agentId, Connection cnx) {
        super(agentId, (byte)18);
        this.cnx = cnx;
    }

    @Override
    public String toString() {
        return "TemporaryQueue" + this.agentId;
    }

    @Override
    public void delete() throws JMSException {
        if (this.cnx == null) {
            throw new JMSSecurityException("Forbidden call as this TemporaryQueue does not belong to this connection.");
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": deleting..."));
        }
        this.cnx.checkConsumers(this.agentId);
        this.cnx.syncRequest((AbstractJmsRequest)new TempDestDeleteRequest(this.agentId));
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": deleted."));
        }
    }

    public Connection getCnx() {
        return this.cnx;
    }
}

