/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import fr.dyade.aaa.common.Debug;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.objectweb.joram.client.jms.Connection;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.client.jms.QueueConnection;
import org.objectweb.joram.client.jms.TopicConnection;
import org.objectweb.joram.client.jms.XAConnection;
import org.objectweb.joram.client.jms.XAQueueConnection;
import org.objectweb.joram.client.jms.XATopicConnection;
import org.objectweb.joram.client.jms.admin.AdministeredObject;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class AbstractConnectionFactory
extends AdministeredObject {
    private static Logger logger = Debug.getLogger((String)AbstractConnectionFactory.class.getName());
    protected FactoryParameters params;
    protected String reliableClass = null;
    protected Identity identity = null;
    protected String identityClassName = SimpleIdentity.class.getName();
    private boolean isSetIdentityClassName = false;
    static final String dfltServerHost = "localhost";
    static final int dfltServerPort = 16010;
    static final String dfltRootLogin = "root";
    static final String dfltRootPassword = "root";
    static final String dfltLogin = "anonymous";
    static final String dfltPassword = "anonymous";

    public AbstractConnectionFactory(String host, int port) {
        this.params = new FactoryParameters(host, port);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": created."));
        }
    }

    public AbstractConnectionFactory(String url) {
        this.params = new FactoryParameters(url);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": created."));
        }
    }

    public AbstractConnectionFactory() {
        this.params = new FactoryParameters();
    }

    public void setIdentityClassName(String identityClassName) {
        this.identityClassName = identityClassName;
        this.isSetIdentityClassName = true;
    }

    protected void initIdentity(String user, String passwd) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("initIdentity(" + user + ", ****)"));
        }
        try {
            if (!this.isSetIdentityClassName) {
                this.identityClassName = System.getProperty("org.objectweb.joram.Identity", SimpleIdentity.class.getName());
            }
            Class<?> clazz = Class.forName(this.identityClassName);
            this.identity = (Identity)clazz.newInstance();
            this.identity.setIdentity(user, passwd);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("initIdentity : identity = " + this.identity));
            }
        }
        catch (ClassNotFoundException e) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)"EXCEPTION:: initIdentity", (Throwable)e);
            }
            throw new JMSException(e.getClass() + ":: " + e.getMessage());
        }
        catch (InstantiationException e) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)"EXCEPTION:: initIdentity", (Throwable)e);
            }
            throw new JMSException(e.getClass() + ":: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)"EXCEPTION:: initIdentity", (Throwable)e);
            }
            throw new JMSException(e.getClass() + ":: " + e.getMessage());
        }
        catch (JMSException exc) {
            throw exc;
        }
        catch (Exception e) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)"EXCEPTION:: initIdentity", (Throwable)e);
            }
            throw new JMSException(e.getClass() + ":: " + e.getMessage());
        }
    }

    public void setReliableClass(String reliableClass) {
        this.reliableClass = reliableClass;
    }

    public static String getDefaultServerHost() {
        return System.getProperty("JoramDfltServerHost", dfltServerHost);
    }

    public static int getDefaultServerPort() {
        return Integer.getInteger("JoramDfltServerPort", 16010);
    }

    public static String getDefaultRootLogin() {
        return System.getProperty("JoramDfltRootLogin", "root");
    }

    public static String getDefaultRootPassword() {
        return System.getProperty("JoramDfltRootPassword", "root");
    }

    public static String getDefaultLogin() {
        return System.getProperty("JoramDfltLogin", "anonymous");
    }

    public static String getDefaultPassword() {
        return System.getProperty("JoramDfltPassword", "anonymous");
    }

    public FactoryParameters getParameters() {
        return this.params;
    }

    protected abstract RequestChannel createRequestChannel(FactoryParameters var1, Identity var2, String var3) throws JMSException;

    public javax.jms.Connection createConnection() throws JMSException {
        return this.createConnection(AbstractConnectionFactory.getDefaultLogin(), AbstractConnectionFactory.getDefaultPassword());
    }

    public javax.jms.Connection createConnection(String name, String password) throws JMSException {
        this.initIdentity(name, password);
        return new Connection(this.params, this.createRequestChannel(this.params, this.identity, this.reliableClass));
    }

    public javax.jms.QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(AbstractConnectionFactory.getDefaultLogin(), AbstractConnectionFactory.getDefaultPassword());
    }

    public javax.jms.QueueConnection createQueueConnection(String name, String password) throws JMSException {
        this.initIdentity(name, password);
        return new QueueConnection(this.params, this.createRequestChannel(this.params, this.identity, this.reliableClass));
    }

    public javax.jms.TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(AbstractConnectionFactory.getDefaultLogin(), AbstractConnectionFactory.getDefaultPassword());
    }

    public javax.jms.TopicConnection createTopicConnection(String name, String password) throws JMSException {
        this.initIdentity(name, password);
        return new TopicConnection(this.params, this.createRequestChannel(this.params, this.identity, this.reliableClass));
    }

    public javax.jms.XAConnection createXAConnection() throws JMSException {
        return this.createXAConnection(AbstractConnectionFactory.getDefaultLogin(), AbstractConnectionFactory.getDefaultPassword());
    }

    public javax.jms.XAConnection createXAConnection(String name, String password) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("TcpConnectionFactory.createXAConnection(" + name + ',' + password + ") reliableClass=" + this.reliableClass));
        }
        this.initIdentity(name, password);
        return new XAConnection(this.params, this.createRequestChannel(this.params, this.identity, this.reliableClass));
    }

    public javax.jms.XAQueueConnection createXAQueueConnection() throws JMSException {
        return this.createXAQueueConnection(AbstractConnectionFactory.getDefaultLogin(), AbstractConnectionFactory.getDefaultPassword());
    }

    public javax.jms.XAQueueConnection createXAQueueConnection(String name, String password) throws JMSException {
        this.initIdentity(name, password);
        return new XAQueueConnection(this.params, this.createRequestChannel(this.params, this.identity, this.reliableClass));
    }

    public javax.jms.XATopicConnection createXATopicConnection() throws JMSException {
        return this.createXATopicConnection(AbstractConnectionFactory.getDefaultLogin(), AbstractConnectionFactory.getDefaultPassword());
    }

    public javax.jms.XATopicConnection createXATopicConnection(String name, String password) throws JMSException {
        this.initIdentity(name, password);
        return new XATopicConnection(this.params, this.createRequestChannel(this.params, this.identity, this.reliableClass));
    }

    @Override
    public final void toReference(Reference ref) throws NamingException {
        this.toReference(ref, "cf");
    }

    public void toReference(Reference ref, String prefix) {
        if (prefix == null) {
            prefix = "cf";
        }
        this.params.toReference(ref, prefix);
        ref.add(new StringRefAddr(prefix + ".reliableClass", this.reliableClass));
        ref.add(new StringRefAddr(prefix + ".identityClassName", this.identityClassName));
    }

    @Override
    public final void fromReference(Reference ref) throws NamingException {
        this.fromReference(ref, "cf");
    }

    public void fromReference(Reference ref, String prefix) {
        if (prefix == null) {
            prefix = "cf";
        }
        this.reliableClass = (String)ref.get(prefix + ".reliableClass").getContent();
        this.setIdentityClassName((String)ref.get(prefix + ".identityClassName").getContent());
        this.params.fromReference(ref, prefix);
    }

    public Hashtable code() {
        return this.code(new Hashtable(), "cf");
    }

    public Hashtable code(Hashtable h, String prefix) {
        if (this.reliableClass != null) {
            h.put(prefix + ".reliableClass", this.reliableClass);
        }
        h.put(prefix + ".identityClassName", this.identityClassName);
        return this.params.code(h, prefix);
    }

    public void decode(Hashtable h) {
        this.decode(h, "cf");
    }

    public void decode(Hashtable h, String prefix) {
        this.reliableClass = (String)h.get(prefix + ".reliableClass");
        this.identityClassName = (String)h.get(prefix + ".identityClassName");
        this.params.decode(h, prefix);
    }
}

