/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import fr.dyade.aaa.common.Debug;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AbstractConnectionFactory;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.AdminWrapper;
import org.objectweb.joram.client.jms.admin.ClusterConnectionFactory;
import org.objectweb.joram.client.jms.admin.ClusterQueue;
import org.objectweb.joram.client.jms.admin.ClusterTopic;
import org.objectweb.joram.client.jms.admin.DeadMQueue;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.client.jms.ha.tcp.HATcpConnectionFactory;
import org.objectweb.joram.client.jms.local.LocalConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class JoramSaxWrapper
extends DefaultHandler {
    public static final String SCN = "scn:comp/";
    public static final String HASCN = "hascn:comp/";
    static final String ELT_JORAMADMIN = "JoramAdmin";
    static final String ELT_ADMINMODULE = "AdminModule";
    static final String ELT_CONNECT = "connect";
    static final String ELT_HACONNECT = "haConnect";
    static final String ELT_COLLOCATEDCONNECT = "collocatedConnect";
    static final String ELT_CONNECTIONFACTORY = "ConnectionFactory";
    static final String ELT_TCP = "tcp";
    static final String ELT_LOCAL = "local";
    static final String ELT_HATCP = "hatcp";
    static final String ELT_HALOCAL = "halocal";
    static final String ELT_SOAP = "soap";
    static final String ELT_JNDI = "jndi";
    static final String ELT_SERVER = "Server";
    static final String ELT_USER = "User";
    static final String ELT_DESTINATION = "Destination";
    static final String ELT_QUEUE = "Queue";
    static final String ELT_TOPIC = "Topic";
    static final String ELT_DMQUEUE = "DMQueue";
    static final String ELT_PROPERTY = "property";
    static final String ELT_READER = "reader";
    static final String ELT_WRITER = "writer";
    static final String ELT_FREEREADER = "freeReader";
    static final String ELT_FREEWRITER = "freeWriter";
    static final String ELT_INITIALCONTEXT = "InitialContext";
    static final String ELT_CLUSTER_CF = "ClusterCF";
    static final String ELT_CLUSTER_QUEUE = "ClusterQueue";
    static final String ELT_CLUSTER_TOPIC = "ClusterTopic";
    static final String ELT_CLUSTER_ELEMENT = "ClusterElement";
    static final String ELT_IN_INTERCEPTORS = "inInterceptors";
    static final String ELT_OUT_INTERCEPTORS = "outInterceptors";
    static final String ELT_INTERCEPTOR = "interceptor";
    static final String ATT_NAME = "name";
    static final String ATT_LOGIN = "login";
    static final String ATT_PASSWORD = "password";
    static final String ATT_VALUE = "value";
    static final String ATT_HOST = "host";
    static final String ATT_PORT = "port";
    static final String ATT_CNXTIMER = "cnxTimer";
    static final String ATT_RELIABLECLASS = "reliableClass";
    static final String ATT_URL = "url";
    static final String ATT_TIMEOUT = "timeout";
    static final String ATT_SERVERID = "serverId";
    static final String ATT_TYPE = "type";
    static final String ATT_CLASSNAME = "className";
    static final String ATT_USER = "user";
    static final String ATT_DMQ = "dmq";
    static final String ATT_NBMAXMSG = "nbMaxMsg";
    static final String ATT_PARENT = "parent";
    static final String ATT_THRESHOLD = "threshold";
    static final String ATT_LOCATION = "location";
    static final String ATT_IDENTITYCLASS = "identityClass";
    static final String DFLT_LISTEN_HOST = "localhost";
    static final int DFLT_LISTEN_PORT = 16010;
    static final String DFLT_CF = "org.objectweb.joram.client.jms.tcp.TcpConnectionFactory";
    Object obj = null;
    String name = null;
    String login = null;
    String password = null;
    String host = null;
    int port = -1;
    int cnxTimer = -1;
    String reliableClass = null;
    String url = null;
    int timeout = -1;
    int serverId = -1;
    String className = null;
    String user = null;
    String type = null;
    Properties properties = null;
    String identityClass = null;
    String jndiName = null;
    Hashtable toBind = new Hashtable();
    Vector readers = new Vector();
    Vector writers = new Vector();
    boolean freeReading = false;
    boolean freeWriting = false;
    List inInterceptorClassname = new ArrayList();
    List outInterceptorClassname = new ArrayList();
    List currentInterceptorList;
    InitialContext jndiCtx = null;
    AdminWrapper defaultWrapper = null;
    AdminWrapper wrapper = null;
    Connection cnx = null;
    Hashtable cfs = new Hashtable();
    Hashtable users = new Hashtable();
    Hashtable queues = new Hashtable();
    Hashtable topics = new Hashtable();
    Hashtable dmqs = new Hashtable();
    Hashtable cluster = new Hashtable();
    String dmq = null;
    int threshold = -1;
    int nbMaxMsg = -1;
    String parent = null;
    String joramAdmName = "default";
    String conf = null;
    public static Logger logger = Debug.getLogger((String)JoramSaxWrapper.class.getName());

    public JoramSaxWrapper() {
    }

    public JoramSaxWrapper(AdminWrapper defaultWrapper) {
        this.defaultWrapper = defaultWrapper;
    }

    AdminWrapper getWrapper() throws ConnectException {
        if (this.wrapper != null) {
            return this.wrapper;
        }
        if (this.defaultWrapper != null) {
            return this.defaultWrapper;
        }
        return AdminModule.getWrapper();
    }

    void close() throws JMSException {
        if (this.wrapper != null) {
            this.wrapper.close();
        }
        if (this.cnx != null) {
            this.cnx.close();
        }
    }

    public void parse(Reader cfgReader, String cfgName) throws Exception {
        this.joramAdmName = cfgName;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        parser.parse(new InputSource(cfgReader), (DefaultHandler)this);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        logger.log(BasicLevel.FATAL, (Object)("fatal error parsing " + e.getPublicId() + " at " + e.getLineNumber() + "." + e.getColumnNumber()));
        throw e;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        logger.log(BasicLevel.ERROR, (Object)("error parsing " + e.getPublicId() + " at " + e.getLineNumber() + "." + e.getColumnNumber()));
        throw e;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (logger.isLoggable(BasicLevel.WARN)) {
            logger.log(BasicLevel.WARN, (Object)("warning parsing " + e.getPublicId() + " at " + e.getLineNumber() + "." + e.getColumnNumber()));
        }
        throw e;
    }

    private final boolean isSet(String value) {
        return value != null && value.length() > 0;
    }

    @Override
    public void startDocument() throws SAXException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"startDocument");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String rawName, Attributes atts) throws SAXException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("JoramSaxWrapper startElement: " + rawName));
        }
        if (rawName.equals(ELT_JORAMADMIN)) {
            this.conf = atts.getValue(ATT_NAME);
            if (this.conf != null) return;
            this.conf = this.joramAdmName;
            return;
        }
        if (!this.joramAdmName.equals(this.conf) || rawName.equals(ELT_ADMINMODULE)) return;
        if (rawName.equals(ELT_CONNECT)) {
            String value;
            this.host = atts.getValue(ATT_HOST);
            if (!this.isSet(this.host)) {
                this.host = DFLT_LISTEN_HOST;
            }
            try {
                value = atts.getValue(ATT_PORT);
                this.port = value == null ? 16010 : Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                throw new SAXException("bad value for port: " + atts.getValue(ATT_PORT));
            }
            this.name = atts.getValue(ATT_NAME);
            if (!this.isSet(this.name)) {
                this.name = AbstractConnectionFactory.getDefaultRootLogin();
            }
            this.password = atts.getValue(ATT_PASSWORD);
            if (!this.isSet(this.password)) {
                this.password = AbstractConnectionFactory.getDefaultRootPassword();
            }
            try {
                value = atts.getValue(ATT_CNXTIMER);
                this.cnxTimer = value == null ? 60 : Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                throw new SAXException("bad value for cnxTimer: " + atts.getValue(ATT_CNXTIMER));
            }
            this.reliableClass = atts.getValue(ATT_RELIABLECLASS);
            this.identityClass = atts.getValue(ATT_IDENTITYCLASS);
            if (this.isSet(this.identityClass)) return;
            this.identityClass = SimpleIdentity.class.getName();
            return;
        }
        if (rawName.equals(ELT_HACONNECT)) {
            this.url = atts.getValue(ATT_URL);
            if (!this.isSet(this.url)) {
                throw new SAXException("URL for HA connection is not defined.");
            }
            this.name = atts.getValue(ATT_NAME);
            if (!this.isSet(this.name)) {
                this.name = AbstractConnectionFactory.getDefaultRootLogin();
            }
            this.password = atts.getValue(ATT_PASSWORD);
            if (!this.isSet(this.password)) {
                this.password = AbstractConnectionFactory.getDefaultRootPassword();
            }
            try {
                String value = atts.getValue(ATT_CNXTIMER);
                this.cnxTimer = value == null ? 60 : Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                throw new SAXException("bad value for cnxTimer: " + atts.getValue(ATT_CNXTIMER));
            }
            this.identityClass = atts.getValue(ATT_IDENTITYCLASS);
            if (this.isSet(this.identityClass)) return;
            this.identityClass = SimpleIdentity.class.getName();
            return;
        }
        if (rawName.equals(ELT_COLLOCATEDCONNECT)) {
            this.name = atts.getValue(ATT_NAME);
            if (!this.isSet(this.name)) {
                this.name = AbstractConnectionFactory.getDefaultRootLogin();
            }
            this.password = atts.getValue(ATT_PASSWORD);
            if (!this.isSet(this.password)) {
                this.password = AbstractConnectionFactory.getDefaultRootPassword();
            }
            this.identityClass = atts.getValue(ATT_IDENTITYCLASS);
            if (this.isSet(this.identityClass)) return;
            this.identityClass = SimpleIdentity.class.getName();
            return;
        }
        if (rawName.equals(ELT_CONNECTIONFACTORY)) {
            this.name = atts.getValue(ATT_NAME);
            this.className = atts.getValue(ATT_CLASSNAME);
            if (!this.isSet(this.className)) {
                this.className = DFLT_CF;
            }
            this.identityClass = atts.getValue(ATT_IDENTITYCLASS);
            return;
        }
        if (rawName.equals(ELT_TCP)) {
            this.host = atts.getValue(ATT_HOST);
            if (!this.isSet(this.host)) {
                this.host = DFLT_LISTEN_HOST;
            }
            try {
                String value = atts.getValue(ATT_PORT);
                this.port = value == null ? 16010 : Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                throw new SAXException("bad value for port: " + atts.getValue(ATT_PORT));
            }
            this.reliableClass = atts.getValue(ATT_RELIABLECLASS);
            return;
        }
        if (rawName.equals(ELT_LOCAL)) return;
        if (rawName.equals(ELT_HATCP)) {
            this.url = atts.getValue(ATT_URL);
            this.reliableClass = atts.getValue(ATT_RELIABLECLASS);
            return;
        }
        if (rawName.equals(ELT_HALOCAL)) return;
        if (rawName.equals(ELT_SOAP)) {
            String value;
            this.host = atts.getValue(ATT_HOST);
            if (!this.isSet(this.host)) {
                this.host = DFLT_LISTEN_HOST;
            }
            try {
                value = atts.getValue(ATT_PORT);
                this.port = value == null ? 16010 : Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                throw new SAXException("bad value for port: " + atts.getValue(ATT_PORT));
            }
            try {
                value = atts.getValue(ATT_TIMEOUT);
                if (value == null) {
                    this.timeout = 60;
                    return;
                }
                this.timeout = Integer.parseInt(value);
                return;
            }
            catch (NumberFormatException exc) {
                throw new SAXException("bad value for cnxTimer: " + atts.getValue(ATT_CNXTIMER));
            }
        }
        if (rawName.equals(ELT_JNDI)) {
            this.jndiName = atts.getValue(ATT_NAME);
            return;
        }
        if (rawName.equals(ELT_SERVER)) {
            String value;
            try {
                value = atts.getValue(ATT_SERVERID);
                this.serverId = value == null ? this.getWrapper().getLocalServerId() : Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                throw new SAXException("bad value for serverId: " + atts.getValue(ATT_SERVERID));
            }
            catch (ConnectException exc) {
                throw new SAXException("error getting serverId: " + exc.getMessage());
            }
            catch (AdminException exc) {
                throw new SAXException("error getting serverId: " + exc.getMessage());
            }
            this.dmq = atts.getValue(ATT_DMQ);
            try {
                value = atts.getValue(ATT_THRESHOLD);
                if (value == null) {
                    this.threshold = -1;
                    return;
                }
                this.threshold = Integer.parseInt(value);
                return;
            }
            catch (NumberFormatException exc) {
                throw new SAXException("bad value for threshold: " + atts.getValue(ATT_THRESHOLD));
            }
        }
        if (rawName.equals(ELT_USER)) {
            String value;
            this.name = atts.getValue(ATT_NAME);
            this.login = atts.getValue(ATT_LOGIN);
            this.password = atts.getValue(ATT_PASSWORD);
            try {
                value = atts.getValue(ATT_SERVERID);
                this.serverId = value == null ? this.getWrapper().getLocalServerId() : Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                throw new SAXException("bad value for serverId: " + atts.getValue(ATT_SERVERID));
            }
            catch (ConnectException exc) {
                throw new SAXException("error getting serverId: " + exc.getMessage());
            }
            catch (AdminException exc) {
                throw new SAXException("error getting serverId: " + exc.getMessage());
            }
            this.dmq = atts.getValue(ATT_DMQ);
            try {
                value = atts.getValue(ATT_THRESHOLD);
                this.threshold = value == null ? -1 : Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                throw new SAXException("bad value for threshold: " + atts.getValue(ATT_THRESHOLD));
            }
            this.identityClass = atts.getValue(ATT_IDENTITYCLASS);
            return;
        }
        if (rawName.equals(ELT_DESTINATION)) {
            this.type = atts.getValue(ATT_TYPE);
            this.name = atts.getValue(ATT_NAME);
            try {
                String value = atts.getValue(ATT_SERVERID);
                this.serverId = value == null ? this.getWrapper().getLocalServerId() : Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                throw new SAXException("bad value for serverId: " + atts.getValue(ATT_SERVERID));
            }
            catch (ConnectException exc) {
                throw new SAXException("error getting serverId: " + exc.getMessage());
            }
            catch (AdminException exc) {
                throw new SAXException("error getting serverId: " + exc.getMessage());
            }
            this.className = atts.getValue(ATT_CLASSNAME);
            this.dmq = atts.getValue(ATT_DMQ);
            return;
        }
        if (rawName.equals(ELT_QUEUE)) {
            String value;
            this.name = atts.getValue(ATT_NAME);
            try {
                value = atts.getValue(ATT_SERVERID);
                this.serverId = value == null ? this.getWrapper().getLocalServerId() : Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                throw new SAXException("bad value for serverId: " + atts.getValue(ATT_SERVERID));
            }
            catch (ConnectException exc) {
                throw new SAXException("error getting serverId: " + exc.getMessage());
            }
            catch (AdminException exc) {
                throw new SAXException("error getting serverId: " + exc.getMessage());
            }
            this.className = atts.getValue(ATT_CLASSNAME);
            this.dmq = atts.getValue(ATT_DMQ);
            try {
                value = atts.getValue(ATT_THRESHOLD);
                this.threshold = value == null ? -1 : Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                throw new SAXException("bad value for threshold: " + atts.getValue(ATT_THRESHOLD));
            }
            try {
                value = atts.getValue(ATT_NBMAXMSG);
                if (value == null) {
                    this.nbMaxMsg = -1;
                    return;
                }
                this.nbMaxMsg = Integer.parseInt(value);
                return;
            }
            catch (NumberFormatException exc) {
                throw new SAXException("bad value for nbMaxMsg: " + atts.getValue(ATT_NBMAXMSG));
            }
        }
        if (rawName.equals(ELT_TOPIC)) {
            this.name = atts.getValue(ATT_NAME);
            try {
                String value = atts.getValue(ATT_SERVERID);
                this.serverId = value == null ? this.getWrapper().getLocalServerId() : Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                throw new SAXException("bad value for serverId: " + atts.getValue(ATT_SERVERID));
            }
            catch (ConnectException exc) {
                throw new SAXException("error getting serverId: " + exc.getMessage());
            }
            catch (AdminException exc) {
                throw new SAXException("error getting serverId: " + exc.getMessage());
            }
            this.className = atts.getValue(ATT_CLASSNAME);
            this.dmq = atts.getValue(ATT_DMQ);
            this.parent = atts.getValue(ATT_PARENT);
            return;
        }
        if (rawName.equals(ELT_DMQUEUE)) {
            this.name = atts.getValue(ATT_NAME);
            try {
                String value = atts.getValue(ATT_SERVERID);
                if (value == null) {
                    this.serverId = this.getWrapper().getLocalServerId();
                    return;
                }
                this.serverId = Integer.parseInt(value);
                return;
            }
            catch (NumberFormatException exc) {
                throw new SAXException("bad value for serverId: " + atts.getValue(ATT_SERVERID));
            }
            catch (ConnectException exc) {
                throw new SAXException("error getting serverId: " + exc.getMessage());
            }
            catch (AdminException exc) {
                throw new SAXException("error getting serverId: " + exc.getMessage());
            }
        } else if (rawName.equals(ELT_PROPERTY)) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.put(atts.getValue(ATT_NAME), atts.getValue(ATT_VALUE));
            return;
        } else if (rawName.equals(ELT_READER)) {
            this.user = atts.getValue(ATT_USER);
            return;
        } else if (rawName.equals(ELT_WRITER)) {
            this.user = atts.getValue(ATT_USER);
            return;
        } else if (rawName.equals(ELT_FREEREADER)) {
            this.freeReading = true;
            return;
        } else if (rawName.equals(ELT_FREEWRITER)) {
            this.freeWriting = true;
            return;
        } else {
            if (rawName.equals(ELT_INITIALCONTEXT)) return;
            if (rawName.equals(ELT_CLUSTER_ELEMENT)) {
                this.cluster.put(atts.getValue(ATT_NAME), atts.getValue(ATT_LOCATION));
                return;
            } else if (rawName.equals(ELT_CLUSTER_QUEUE)) {
                this.cluster.clear();
                return;
            } else if (rawName.equals(ELT_CLUSTER_TOPIC)) {
                this.cluster.clear();
                return;
            } else if (rawName.equals(ELT_CLUSTER_CF)) {
                this.cluster.clear();
                return;
            } else if (rawName.equals(ELT_IN_INTERCEPTORS)) {
                this.currentInterceptorList = this.inInterceptorClassname;
                return;
            } else if (rawName.equals(ELT_OUT_INTERCEPTORS)) {
                this.currentInterceptorList = this.outInterceptorClassname;
                return;
            } else {
                if (!rawName.equals(ELT_INTERCEPTOR)) throw new SAXException("unknown element \"" + rawName + "\"");
                String interceptorCN = atts.getValue(ATT_CLASSNAME);
                if (!this.isSet(interceptorCN)) throw new SAXException("Element \"" + rawName + "\" must provide \"" + ATT_CLASSNAME + "\" attribute. ");
                this.currentInterceptorList.add(interceptorCN);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String rawName) throws SAXException {
        block118: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("JoramSaxWrapper endElement: " + rawName));
            }
            if (rawName.equals(ELT_JORAMADMIN)) {
                this.conf = null;
            } else if (this.joramAdmName.equals(this.conf)) {
                try {
                    if (rawName.equals(ELT_ADMINMODULE)) break block118;
                    if (rawName.equals(ELT_CONNECT)) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("JoramSaxWrapper creates wrapper (TCP): " + this.host + ',' + this.port + ',' + this.name));
                        }
                        ConnectionFactory cf = TcpConnectionFactory.create(this.host, this.port, this.reliableClass);
                        cf.getParameters().connectingTimer = this.cnxTimer;
                        cf.setIdentityClassName(this.identityClass);
                        this.cnx = cf.createConnection(this.name, this.password);
                        this.cnx.start();
                        this.wrapper = new AdminWrapper(this.cnx);
                        break block118;
                    }
                    if (rawName.equals(ELT_HACONNECT)) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("JoramSaxWrapper creates wrapper (HA): " + this.url + ',' + this.name));
                        }
                        ConnectionFactory cf = HATcpConnectionFactory.create(this.url);
                        cf.getParameters().connectingTimer = this.cnxTimer;
                        cf.setIdentityClassName(this.identityClass);
                        this.cnx = cf.createConnection(this.name, this.password);
                        this.cnx.start();
                        this.wrapper = new AdminWrapper(this.cnx);
                        break block118;
                    }
                    if (rawName.equals(ELT_COLLOCATEDCONNECT)) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("JoramSaxWrapper creates wrapper (Local): " + this.name));
                        }
                        ConnectionFactory cf = LocalConnectionFactory.create();
                        cf.setIdentityClassName(this.identityClass);
                        this.cnx = cf.createConnection(this.name, this.password);
                        this.cnx.start();
                        this.wrapper = new AdminWrapper(this.cnx);
                        break block118;
                    }
                    if (rawName.equals(ELT_CONNECTIONFACTORY)) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("cf \"" + this.name + "\"= " + this.obj));
                        }
                        if (this.isSet(this.identityClass)) {
                            ((AbstractConnectionFactory)this.obj).setIdentityClassName(this.identityClass);
                        }
                        if (this.isSet(this.jndiName)) {
                            this.toBind.put(this.jndiName, this.obj);
                        }
                        this.jndiName = null;
                        if (this.isSet(this.name)) {
                            this.cfs.put(this.name, this.obj);
                        }
                        if (this.inInterceptorClassname != null && !this.inInterceptorClassname.isEmpty()) {
                            for (String iicn : this.inInterceptorClassname) {
                                ((AbstractConnectionFactory)this.obj).getParameters().addInInterceptor(iicn);
                            }
                            this.inInterceptorClassname.clear();
                        }
                        if (this.outInterceptorClassname != null && !this.outInterceptorClassname.isEmpty()) {
                            for (String oicn : this.outInterceptorClassname) {
                                ((AbstractConnectionFactory)this.obj).getParameters().addOutInterceptor(oicn);
                            }
                            this.outInterceptorClassname.clear();
                        }
                        this.className = null;
                        this.obj = null;
                        this.identityClass = null;
                        break block118;
                    }
                    if (rawName.equals(ELT_TCP)) {
                        try {
                            Class<?> clazz = Class.forName(this.className);
                            Class[] classParams = new Class[]{new String().getClass(), Integer.TYPE, new String().getClass()};
                            Method methode = clazz.getMethod("create", classParams);
                            Object[] objParams = new Object[]{this.host, new Integer(this.port), this.reliableClass};
                            this.obj = methode.invoke(null, objParams);
                            break block118;
                        }
                        catch (Throwable exc) {
                            logger.log(BasicLevel.ERROR, (Object)("JoramSaxWrapper: Cannot instantiate " + this.className), exc);
                            throw new SAXException(exc.getMessage());
                        }
                    }
                    if (rawName.equals(ELT_LOCAL)) {
                        try {
                            Class<?> clazz = Class.forName(this.className);
                            Method methode = clazz.getMethod("create", new Class[0]);
                            this.obj = methode.invoke(null, new Object[0]);
                            break block118;
                        }
                        catch (Throwable exc) {
                            logger.log(BasicLevel.ERROR, (Object)("JoramSaxWrapper: Cannot instantiate " + this.className), exc);
                            throw new SAXException(exc.getMessage());
                        }
                    }
                    if (rawName.equals(ELT_HATCP)) {
                        try {
                            Class<?> clazz = Class.forName(this.className);
                            Class[] classParams = new Class[]{new String().getClass(), new String().getClass()};
                            Method methode = clazz.getMethod("create", classParams);
                            Object[] objParams = new Object[]{this.url, this.reliableClass};
                            this.obj = methode.invoke(null, objParams);
                            break block118;
                        }
                        catch (Throwable exc) {
                            logger.log(BasicLevel.ERROR, (Object)("JoramSaxWrapper: Cannot instantiate " + this.className), exc);
                            throw new SAXException(exc.getMessage());
                        }
                    }
                    if (rawName.equals(ELT_HALOCAL)) {
                        try {
                            Class<?> clazz = Class.forName(this.className);
                            Method methode = clazz.getMethod("create", new Class[0]);
                            this.obj = methode.invoke(null, new Object[0]);
                            break block118;
                        }
                        catch (Throwable exc) {
                            logger.log(BasicLevel.ERROR, (Object)("JoramSaxWrapper: Cannot instantiate " + this.className), exc);
                            throw new SAXException(exc.getMessage());
                        }
                    }
                    if (rawName.equals(ELT_SOAP)) {
                        try {
                            Class<?> clazz = Class.forName(this.className);
                            Class[] classParams = new Class[]{new String().getClass(), Integer.TYPE, Integer.TYPE};
                            Method methode = clazz.getMethod("create", classParams);
                            Object[] objParams = new Object[]{this.host, new Integer(this.port), new Integer(this.timeout)};
                            this.obj = methode.invoke(null, objParams);
                            break block118;
                        }
                        catch (Throwable exc) {
                            logger.log(BasicLevel.ERROR, (Object)("JoramSaxWrapper: Cannot instantiate " + this.className), exc);
                            throw new SAXException(exc.getMessage());
                        }
                    }
                    if (!rawName.equals(ELT_JNDI)) {
                        if (rawName.equals(ELT_SERVER)) {
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)("Server.configure(" + this.serverId + ")"));
                            }
                            if (this.threshold > 0) {
                                this.getWrapper().setDefaultThreshold(this.serverId, this.threshold);
                            }
                            if (this.isSet(this.dmq)) {
                                if (this.dmqs.containsKey(this.dmq)) {
                                    this.getWrapper().setDefaultDMQ(this.serverId, (DeadMQueue)this.dmqs.get(this.dmq));
                                } else {
                                    logger.log(BasicLevel.ERROR, (Object)("Cannot set default DMQ, unknown DMQ: " + this.dmq));
                                }
                            }
                        } else if (rawName.equals(ELT_USER)) {
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)("User.create(" + this.name + "," + this.login + "," + "-," + this.serverId + ")"));
                            }
                            if (!this.isSet(this.login)) {
                                this.login = this.name;
                            }
                            if (!this.isSet(this.identityClass)) {
                                this.identityClass = SimpleIdentity.class.getName();
                            }
                            User user = this.getWrapper().createUser(this.login, this.password, this.serverId, this.identityClass);
                            this.users.put(this.name, user);
                            if (this.threshold > 0) {
                                user.setThreshold(this.threshold);
                            }
                            if (this.isSet(this.dmq)) {
                                if (this.dmqs.containsKey(this.dmq)) {
                                    user.setDMQ((DeadMQueue)this.dmqs.get(this.dmq));
                                } else {
                                    logger.log(BasicLevel.ERROR, (Object)("User.create(), unknown DMQ: " + this.dmq));
                                }
                            }
                        } else if (rawName.equals(ELT_DESTINATION)) {
                            Destination dest = null;
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)("dest type =" + this.type));
                            }
                            if (this.type.equals("queue")) {
                                if (this.className == null) {
                                    this.className = "org.objectweb.joram.mom.dest.Queue";
                                }
                                if (logger.isLoggable(BasicLevel.DEBUG)) {
                                    logger.log(BasicLevel.DEBUG, (Object)("Queue.create(" + this.serverId + "," + this.name + "," + this.className + "," + this.properties + ")"));
                                }
                                dest = this.getWrapper().createQueue(this.serverId, this.name, this.className, this.properties);
                            } else if (this.type.equals("topic")) {
                                if (this.className == null) {
                                    this.className = "org.objectweb.joram.mom.dest.Topic";
                                }
                                if (logger.isLoggable(BasicLevel.DEBUG)) {
                                    logger.log(BasicLevel.DEBUG, (Object)("Topic.create(" + this.serverId + "," + this.name + "," + this.className + "," + this.properties + ")"));
                                }
                                dest = this.getWrapper().createTopic(this.serverId, this.name, this.className, this.properties);
                            } else {
                                throw new Exception("type " + this.type + " bad value. (queue or topic)");
                            }
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)("destination = " + dest));
                            }
                            this.properties = null;
                            this.configureDestination(dest);
                            if (this.isSet(this.jndiName)) {
                                this.toBind.put(this.jndiName, dest);
                            }
                            this.jndiName = null;
                            String name = dest.getAdminName();
                            if (!this.isSet(name)) {
                                name = dest.getName();
                            }
                            if (dest instanceof Queue) {
                                this.queues.put(name, dest);
                            } else {
                                this.topics.put(name, dest);
                            }
                            this.setDestinationDMQ(dest, this.dmq);
                        } else if (rawName.equals(ELT_QUEUE)) {
                            if (this.className == null) {
                                this.className = "org.objectweb.joram.mom.dest.Queue";
                            }
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)("Queue.create(" + this.serverId + "," + this.name + "," + this.className + "," + this.properties + ")"));
                            }
                            Queue queue = (Queue)this.getWrapper().createQueue(this.serverId, this.name, this.className, this.properties);
                            this.properties = null;
                            this.configureDestination(queue);
                            if (this.threshold > 0) {
                                queue.setThreshold(this.threshold);
                            }
                            if (this.nbMaxMsg > 0) {
                                queue.setNbMaxMsg(this.nbMaxMsg);
                            }
                            if (this.isSet(this.jndiName)) {
                                this.toBind.put(this.jndiName, queue);
                            }
                            this.jndiName = null;
                            String name = queue.getAdminName();
                            if (!this.isSet(name)) {
                                name = queue.getName();
                            }
                            this.queues.put(name, queue);
                            this.setDestinationDMQ(queue, this.dmq);
                        } else if (rawName.equals(ELT_TOPIC)) {
                            if (this.className == null) {
                                this.className = "org.objectweb.joram.mom.dest.Topic";
                            }
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)("Topic.create(" + this.serverId + "," + this.name + "," + this.className + "," + this.properties + ")"));
                            }
                            Topic topic = (Topic)this.getWrapper().createTopic(this.serverId, this.name, this.className, this.properties);
                            this.properties = null;
                            this.configureDestination(topic);
                            if (this.isSet(this.parent)) {
                                if (this.topics.containsKey(this.parent)) {
                                    topic.setParent((Topic)this.topics.get(this.parent));
                                } else {
                                    logger.log(BasicLevel.ERROR, (Object)("Topic.create(): Unknown parent: " + this.parent));
                                }
                            }
                            if (this.isSet(this.jndiName)) {
                                this.toBind.put(this.jndiName, topic);
                            }
                            this.jndiName = null;
                            String name = topic.getAdminName();
                            if (!this.isSet(name)) {
                                name = topic.getName();
                            }
                            this.topics.put(name, topic);
                            this.setDestinationDMQ(topic, this.dmq);
                        } else if (rawName.equals(ELT_DMQUEUE)) {
                            this.className = "org.objectweb.joram.mom.dest.DeadMQueue";
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)("DeadMQueue.create(" + this.serverId + "," + this.name + ")"));
                            }
                            DeadMQueue dmq = (DeadMQueue)this.getWrapper().createDeadMQueue(this.serverId, this.name);
                            this.configureDestination(dmq);
                            if (this.isSet(this.jndiName)) {
                                this.toBind.put(this.jndiName, dmq);
                            }
                            this.jndiName = null;
                            if (this.isSet(this.name)) {
                                this.dmqs.put(this.name, dmq);
                            }
                        } else if (!rawName.equals(ELT_PROPERTY)) {
                            if (rawName.equals(ELT_READER)) {
                                this.readers.add(this.user);
                            } else if (rawName.equals(ELT_WRITER)) {
                                this.writers.add(this.user);
                            } else if (!rawName.equals(ELT_FREEREADER) && !rawName.equals(ELT_FREEWRITER)) {
                                if (rawName.equals(ELT_INITIALCONTEXT)) {
                                    try {
                                        this.jndiCtx = new InitialContext(this.properties);
                                    }
                                    catch (NamingException exc) {
                                        logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
                                    }
                                } else if (!rawName.equals(ELT_CLUSTER_ELEMENT)) {
                                    if (rawName.equals(ELT_CLUSTER_CF)) {
                                        Map.Entry[] entries = new Map.Entry[this.cluster.size()];
                                        this.cluster.entrySet().toArray(entries);
                                        ClusterConnectionFactory clusterCF = new ClusterConnectionFactory();
                                        for (int i = 0; i < entries.length; ++i) {
                                            ConnectionFactory cf = (ConnectionFactory)this.cfs.get(entries[i].getKey());
                                            clusterCF.addConnectionFactory((String)entries[i].getValue(), cf);
                                        }
                                        this.cluster.clear();
                                        if (this.isSet(this.jndiName)) {
                                            this.toBind.put(this.jndiName, clusterCF);
                                        }
                                        this.jndiName = null;
                                    } else if (rawName.equals(ELT_CLUSTER_QUEUE)) {
                                        Map.Entry[] entries = new Map.Entry[this.cluster.size()];
                                        this.cluster.entrySet().toArray(entries);
                                        ClusterQueue clusterQueue = new ClusterQueue();
                                        Queue root = null;
                                        for (int i = 0; i < entries.length; ++i) {
                                            Queue queue = (Queue)this.queues.get(entries[i].getKey());
                                            clusterQueue.addDestination((String)entries[i].getValue(), queue);
                                            if (i == 0) {
                                                root = queue;
                                                continue;
                                            }
                                            root.addClusteredQueue(queue);
                                        }
                                        this.cluster.clear();
                                        this.configureDestination(clusterQueue);
                                        if (this.isSet(this.jndiName)) {
                                            this.toBind.put(this.jndiName, clusterQueue);
                                        }
                                        this.jndiName = null;
                                    } else if (rawName.equals(ELT_CLUSTER_TOPIC)) {
                                        Map.Entry[] entries = new Map.Entry[this.cluster.size()];
                                        this.cluster.entrySet().toArray(entries);
                                        ClusterTopic clusterTopic = new ClusterTopic();
                                        Topic root = null;
                                        for (int i = 0; i < entries.length; ++i) {
                                            Topic topic = (Topic)this.topics.get(entries[i].getKey());
                                            clusterTopic.addDestination((String)entries[i].getValue(), topic);
                                            if (i == 0) {
                                                root = topic;
                                                continue;
                                            }
                                            root.addClusteredTopic(topic);
                                        }
                                        this.cluster.clear();
                                        this.configureDestination(clusterTopic);
                                        if (this.isSet(this.jndiName)) {
                                            this.toBind.put(this.jndiName, clusterTopic);
                                        }
                                        this.jndiName = null;
                                    } else if (!(rawName.equals(ELT_IN_INTERCEPTORS) || rawName.equals(ELT_OUT_INTERCEPTORS) || rawName.equals(ELT_INTERCEPTOR))) {
                                        throw new SAXException("unknown element \"" + rawName + "\"");
                                    }
                                }
                            }
                        }
                    }
                }
                catch (SAXException exc) {
                    throw exc;
                }
                catch (Exception exc) {
                    logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
                    throw new SAXException(exc.getMessage(), exc);
                }
            }
        }
    }

    void configureDestination(Destination dest) throws Exception {
        User u;
        int i;
        if (this.freeReading) {
            dest.setFreeReading();
        }
        this.freeReading = false;
        if (this.freeWriting) {
            dest.setFreeWriting();
        }
        this.freeWriting = false;
        for (i = 0; i < this.readers.size(); ++i) {
            u = (User)this.users.get(this.readers.get(i));
            if (u == null) continue;
            dest.setReader(u);
        }
        this.readers.clear();
        for (i = 0; i < this.writers.size(); ++i) {
            u = (User)this.users.get(this.writers.get(i));
            if (u == null) continue;
            dest.setWriter(u);
        }
        this.writers.clear();
    }

    void setDestinationDMQ(Destination dest, String dmq) throws Exception {
        if (this.isSet(dmq)) {
            if (this.dmqs.containsKey(dmq)) {
                dest.setDMQ((DeadMQueue)this.dmqs.get(dmq));
            } else {
                logger.log(BasicLevel.ERROR, (Object)("Destination.create(): Unknown DMQ: " + dmq));
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"endDocument");
        }
        try {
            this.close();
        }
        catch (JMSException exc) {
            logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
        }
        try {
            if (this.jndiCtx == null) {
                this.jndiCtx = new InitialContext();
            }
            Enumeration e = this.toBind.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                StringBuffer buff = null;
                StringTokenizer st = null;
                if (name.startsWith(SCN)) {
                    buff = new StringBuffer(SCN);
                    st = new StringTokenizer(name.substring(SCN.length(), name.length()), "/");
                } else if (name.startsWith(HASCN)) {
                    buff = new StringBuffer(HASCN);
                    st = new StringTokenizer(name.substring(HASCN.length(), name.length()), "/");
                } else {
                    buff = new StringBuffer();
                    st = new StringTokenizer(name, "/");
                }
                buff.append(st.nextToken());
                while (st.hasMoreTokens()) {
                    block16: {
                        try {
                            this.jndiCtx.createSubcontext(buff.toString());
                        }
                        catch (NameAlreadyBoundException exc) {
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)("createSubcontext:: NameAlreadyBoundException" + buff.toString()));
                            }
                        }
                        catch (NamingException exc) {
                            if (!logger.isLoggable(BasicLevel.WARN)) break block16;
                            logger.log(BasicLevel.WARN, (Object)"createSubcontext", (Throwable)exc);
                        }
                    }
                    buff.append("/");
                    buff.append(st.nextToken());
                }
                this.jndiCtx.rebind(name, this.toBind.get(name));
            }
            this.jndiCtx.close();
            this.toBind.clear();
        }
        catch (NamingException exc) {
            logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
        }
    }
}

