/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.tcp;

import fr.dyade.aaa.common.Debug;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.objectweb.joram.client.jms.tcp.ReliableTcpClient;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ReliableSSLTcpClient
extends ReliableTcpClient {
    private static Logger logger = Debug.getLogger((String)ReliableSSLTcpClient.class.getName());
    private static final String KS = "org.objectweb.joram.keystore";
    private static final String KS_PASS = "org.objectweb.joram.keystorepass";
    private static final String KS_TYPE = "org.objectweb.joram.keystoretype";
    private static final String SSLCONTEXT = "org.objectweb.joram.sslCtx";

    @Override
    protected Socket createSocket(String hostname, int port) throws Exception {
        InetAddress outLocalAddr = null;
        String outLocalAddrStr = this.params.outLocalAddress;
        if (outLocalAddrStr != null) {
            outLocalAddr = InetAddress.getByName(outLocalAddrStr);
        }
        int outLocalPort = this.params.outLocalPort;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ReliableSSLTcpClient[" + this.identity + ',' + this.key + "].createSocket(" + hostname + "," + port + ") on interface " + outLocalAddrStr + ":" + outLocalPort));
        }
        SocketFactory socketFactory = ReliableSSLTcpClient.createSocketFactory();
        Socket socket = socketFactory.createSocket(hostname, port, outLocalAddr, outLocalPort);
        return socket;
    }

    private static SocketFactory createSocketFactory() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ReliableSSLTcpClient.createSocketFactory()");
        }
        char[] keyStorePass = System.getProperty(KS_PASS, "jorampass").toCharArray();
        String keystoreFile = System.getProperty(KS, "./joram_ks");
        String sslContext = System.getProperty(SSLCONTEXT, "SSL");
        String ksType = System.getProperty(KS_TYPE, "JKS");
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("SSLTcpProxyService.createSocketFactory : keystoreFile=" + keystoreFile));
        }
        KeyStore keystore = KeyStore.getInstance(ksType);
        keystore.load(new FileInputStream(keystoreFile), keyStorePass);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keystore, keyStorePass);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(keystore);
        TrustManager[] trustManagers = tmf.getTrustManagers();
        SSLContext ctx = SSLContext.getInstance(sslContext);
        SecureRandom securerandom = SecureRandom.getInstance("SHA1PRNG");
        ctx.init(kmf.getKeyManagers(), trustManagers, securerandom);
        return ctx.getSocketFactory();
    }
}

