/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.tcp;

import fr.dyade.aaa.common.Debug;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.objectweb.joram.shared.client.AbstractJmsMessage;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.stream.StreamUtil;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ReliableTcpConnection {
    public static final int INIT = 0;
    public static final int CONNECT = 1;
    public static final int CONNECTING = 2;
    public static final String[] statusNames = new String[]{"INIT", "CONNECT", "CONNECTING"};
    public static Logger logger = Debug.getLogger((String)"fr.dyade.aaa.util.ReliableTcpConnection");
    public static String WINDOW_SIZE_PROP_NAME = "fr.dyade.aaa.util.ReliableTcpConnection.windowSize";
    public static int DEFAULT_WINDOW_SIZE = 100;
    private int windowSize = Integer.getInteger(WINDOW_SIZE_PROP_NAME, DEFAULT_WINDOW_SIZE);
    private volatile long inputCounter;
    private long outputCounter;
    private volatile int unackCounter;
    private Vector pendingMessages;
    private Socket sock;
    private NetOutputStream nos;
    private BufferedInputStream bis;
    private Object inputLock;
    private Object outputLock;
    private int status;
    private Timer timer;

    public ReliableTcpConnection(Timer timer2) {
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)("ReliableTcpConnection.windowSize=" + this.windowSize));
        }
        this.timer = timer2;
        this.inputCounter = -1L;
        this.outputCounter = 0L;
        this.unackCounter = 0;
        this.pendingMessages = new Vector();
        this.inputLock = new Object();
        this.outputLock = new Object();
        this.setStatus(0);
    }

    private synchronized void setStatus(int status) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ReliableTcpConnection.setStatus(" + statusNames[status] + ')'));
        }
        this.status = status;
    }

    private final synchronized int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Socket sock) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ReliableTcpConnection.init()");
        }
        Object object = this;
        synchronized (object) {
            if (this.getStatus() != 0) {
                throw new IOException("Already connected");
            }
            this.setStatus(2);
        }
        try {
            this.sock = sock;
            object = this.outputLock;
            synchronized (object) {
                this.nos = new NetOutputStream(sock);
                Vector vector = this.pendingMessages;
                synchronized (vector) {
                    for (int i = 0; i < this.pendingMessages.size(); ++i) {
                        TcpMessage pendingMsg = (TcpMessage)this.pendingMessages.elementAt(i);
                        this.doSend(pendingMsg.id, this.inputCounter, pendingMsg.object);
                    }
                }
            }
            object = this.inputLock;
            synchronized (object) {
                this.bis = new BufferedInputStream(sock.getInputStream());
            }
            this.setStatus(1);
        }
        catch (IOException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.close();
            throw exc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(AbstractJmsMessage request) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ReliableTcpConnection.send(" + request + ')'));
        }
        if (this.getStatus() != 1) {
            throw new IOException("Connection closed");
        }
        try {
            Object object = this.outputLock;
            synchronized (object) {
                this.doSend(this.outputCounter, this.inputCounter, request);
                this.addPendingMessage(new TcpMessage(this.outputCounter, request));
                ++this.outputCounter;
            }
        }
        catch (IOException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"ReliableTcpConnection.send()", (Throwable)exc);
            }
            this.close();
            throw exc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend(long id, long ackId, AbstractJmsMessage msg) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ReliableTcpConnection.doSend(" + id + ',' + ackId + ',' + msg + ')'));
        }
        Object object = this.outputLock;
        synchronized (object) {
            this.nos.send(id, ackId, msg);
            this.unackCounter = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingMessage(TcpMessage msg) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ReliableTcpConnection.addPendingMessage(" + msg + ')'));
        }
        Vector vector = this.pendingMessages;
        synchronized (vector) {
            this.pendingMessages.addElement(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ackPendingMessages(long ackId) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ReliableTcpConnection.ackPendingMessages(" + ackId + ')'));
        }
        Vector vector = this.pendingMessages;
        synchronized (vector) {
            while (this.pendingMessages.size() > 0) {
                TcpMessage pendingMsg = (TcpMessage)this.pendingMessages.elementAt(0);
                if (ackId < pendingMsg.id) break;
                this.pendingMessages.removeElementAt(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractJmsReply receive() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ReliableTcpConnection.receive()");
        }
        if (this.getStatus() != 1) {
            throw new IOException("Connection closed");
        }
        try {
            while (true) {
                AbstractJmsReply obj;
                long ackId;
                long messageId;
                Object object = this.inputLock;
                synchronized (object) {
                    int len = StreamUtil.readIntFrom((InputStream)this.bis);
                    messageId = StreamUtil.readLongFrom((InputStream)this.bis);
                    ackId = StreamUtil.readLongFrom((InputStream)this.bis);
                    obj = (AbstractJmsReply)AbstractJmsMessage.read((InputStream)this.bis);
                }
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(" -> id = " + messageId));
                }
                this.ackPendingMessages(ackId);
                if (obj == null) continue;
                if (this.unackCounter < this.windowSize) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)" -> unackCounter++");
                    }
                    ++this.unackCounter;
                } else {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)" -> schedule");
                    }
                    AckTimerTask ackTimertask = new AckTimerTask();
                    this.timer.schedule((TimerTask)ackTimertask, 0L);
                }
                if (messageId > this.inputCounter) {
                    this.inputCounter = messageId;
                    return obj;
                }
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)(" -> already received message: " + messageId + " " + obj));
            }
        }
        catch (IOException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.close();
            throw exc;
        }
    }

    public void close() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ReliableTcpConnection.close()");
        }
        if (this.getStatus() == 0) {
            return;
        }
        try {
            this.sock.getOutputStream().close();
        }
        catch (IOException exc) {
            // empty catch block
        }
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setStatus(0);
    }

    class AckTimerTask
    extends TimerTask {
        AckTimerTask() {
        }

        @Override
        public void run() {
            block3: {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"AckTimerTask.run()");
                }
                try {
                    ReliableTcpConnection.this.doSend(-1L, ReliableTcpConnection.this.inputCounter, null);
                    this.cancel();
                }
                catch (IOException exc) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                    logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                }
            }
        }
    }

    static class TcpMessage {
        long id;
        AbstractJmsMessage object;

        TcpMessage(long id, AbstractJmsMessage object) {
            this.id = id;
            this.object = object;
        }

        public String toString() {
            return '(' + super.toString() + ",id=" + this.id + ",object=" + this.object + ')';
        }
    }

    static class NetOutputStream
    extends ByteArrayOutputStream {
        private OutputStream os = null;

        NetOutputStream(Socket sock) throws IOException {
            super(1024);
            this.reset();
            this.os = sock.getOutputStream();
        }

        @Override
        public void reset() {
            this.count = 4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void send(long id, long ackId, AbstractJmsMessage msg) throws IOException {
            try {
                StreamUtil.writeTo((long)id, (OutputStream)this);
                StreamUtil.writeTo((long)ackId, (OutputStream)this);
                AbstractJmsMessage.write((AbstractJmsMessage)msg, (OutputStream)this);
                this.buf[0] = (byte)(this.count - 4 >>> 24);
                this.buf[1] = (byte)(this.count - 4 >>> 16);
                this.buf[2] = (byte)(this.count - 4 >>> 8);
                this.buf[3] = (byte)(this.count - 4 >>> 0);
                this.writeTo(this.os);
                this.os.flush();
            }
            finally {
                this.reset();
            }
        }
    }
}

