/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.MonitoringTimerTaskMBean;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanAttributeInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class MonitoringTimerTask
extends TimerTask
implements MonitoringTimerTaskMBean {
    protected long period;
    Properties attlist = null;
    FileWriter writer;
    public static Logger logger = Debug.getLogger(MonitoringTimerTask.class.getName());

    @Override
    public long getPeriod() {
        return this.period;
    }

    public MonitoringTimerTask(Timer timer, long period, String path, Properties attlist) {
        this.period = period;
        this.attlist = attlist;
        try {
            this.writer = new FileWriter(path, true);
        }
        catch (IOException exc) {
            logger.log(BasicLevel.ERROR, (Object)("MonitoringTimerTask.<init>, cannot open file \"" + path + "\""), (Throwable)exc);
        }
        timer.scheduleAtFixedRate((TimerTask)this, period, period);
    }

    @Override
    public void run() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(System.currentTimeMillis()).append(';');
        Enumeration<Object> mbeans = this.attlist.keys();
        while (mbeans.hasMoreElements()) {
            String name = (String)mbeans.nextElement();
            Set mBeans = null;
            try {
                mBeans = MXWrapper.queryNames(new ObjectName(name));
            }
            catch (MalformedObjectNameException exc) {
                logger.log(BasicLevel.ERROR, (Object)("MonitoringTimerTask.run, bad name: " + name), (Throwable)exc);
            }
            if (mBeans == null) continue;
            for (ObjectName mBean : mBeans) {
                StringTokenizer st = new StringTokenizer((String)this.attlist.get(name), ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.equals("*")) {
                        try {
                            MBeanAttributeInfo[] attributes = MXWrapper.getAttributes(mBean);
                            if (attributes == null) continue;
                            for (int i = 0; i < attributes.length; ++i) {
                                String attname = attributes[i].getName();
                                strbuf.append(mBean).append(':').append(attname).append(';');
                                try {
                                    strbuf.append(MXWrapper.getAttribute(mBean, attname));
                                }
                                catch (Exception exc) {
                                    logger.log(BasicLevel.ERROR, (Object)("MonitoringTimerTask.run, bad attribute : " + mBean + ":" + attname), (Throwable)exc);
                                }
                                strbuf.append(';');
                            }
                            continue;
                        }
                        catch (Exception exc) {
                            logger.log(BasicLevel.ERROR, (Object)"MonitoringTimerTask.run", (Throwable)exc);
                            continue;
                        }
                    }
                    String attname = token.trim();
                    strbuf.append(mBean).append(':').append(attname).append(';');
                    try {
                        strbuf.append(MXWrapper.getAttribute(mBean, attname));
                    }
                    catch (Exception exc) {
                        logger.log(BasicLevel.ERROR, (Object)("MonitoringTimerTask.run, bad attribute : " + mBean + ":" + attname), (Throwable)exc);
                    }
                    strbuf.append(';');
                }
            }
        }
        strbuf.append('\n');
        try {
            this.writer.write(strbuf.toString());
            this.writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String[] getMonitoredAttributes() {
        int i = 0;
        String[] ret = new String[this.attlist.size()];
        Enumeration<Object> e = this.attlist.keys();
        while (e.hasMoreElements()) {
            String mbean = (String)e.nextElement();
            ret[i++] = mbean + '=' + this.attlist.getProperty(mbean);
        }
        return ret;
    }

    @Override
    public void addMonitoredAttributes(String MBeanName, String attributes) {
        this.attlist.put(MBeanName, attributes);
    }

    @Override
    public void delMonitoredAttributes(String MBeanName) {
        this.attlist.remove(MBeanName);
    }
}

