/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.util.ResolverObjectInputStream;
import fr.dyade.aaa.util.Transaction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

public abstract class AbstractTransaction
implements Transaction {
    protected int phase;
    protected ThreadLocal perThreadContext = null;
    protected static final byte[] OOS_STREAM_HEADER = new byte[]{-84, -19, 0, 5};

    @Override
    public final int getPhase() {
        return this.phase;
    }

    @Override
    public final String getPhaseInfo() {
        return PhaseInfo[this.phase];
    }

    protected abstract void setPhase(int var1) throws IOException;

    @Override
    public final synchronized void begin() throws IOException {
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setPhase(2);
    }

    @Override
    public final void create(Serializable obj, String name) throws IOException {
        this.save(obj, null, name, true);
    }

    @Override
    public final void create(Serializable obj, String dirName, String name) throws IOException {
        this.save(obj, dirName, name, true);
    }

    @Override
    public final void save(Serializable obj, String name) throws IOException {
        this.save(obj, null, name, false);
    }

    @Override
    public final void save(Serializable obj, String dirName, String name) throws IOException {
        this.save(obj, dirName, name, false);
    }

    @Override
    public final void save(Serializable obj, String dirName, String name, boolean first) throws IOException {
        Context ctx = (Context)this.perThreadContext.get();
        if (ctx.oos == null) {
            ctx.bos.reset();
            ctx.oos = new ObjectOutputStream(ctx.bos);
        } else {
            ctx.oos.reset();
            ctx.bos.reset();
            ctx.bos.write(OOS_STREAM_HEADER, 0, 4);
        }
        ctx.oos.writeObject(obj);
        ctx.oos.flush();
        this.saveInLog(ctx.bos.toByteArray(), dirName, name, ctx.log, false, first);
    }

    @Override
    public final void createByteArray(byte[] buf, String name) throws IOException {
        this.saveByteArray(buf, null, name, true, true);
    }

    @Override
    public final void createByteArray(byte[] buf, String dirName, String name) throws IOException {
        this.saveByteArray(buf, dirName, name, true, true);
    }

    @Override
    public final void saveByteArray(byte[] buf, String name) throws IOException {
        this.saveByteArray(buf, null, name, true, false);
    }

    @Override
    public final void saveByteArray(byte[] buf, String dirName, String name) throws IOException {
        this.saveByteArray(buf, dirName, name, true, false);
    }

    @Override
    public final void saveByteArray(byte[] buf, String dirName, String name, boolean copy, boolean first) throws IOException {
        this.saveInLog(buf, dirName, name, ((Context)this.perThreadContext.get()).log, copy, first);
    }

    protected abstract void saveInLog(byte[] var1, String var2, String var3, Hashtable var4, boolean var5, boolean var6) throws IOException;

    @Override
    public final Object load(String name) throws IOException, ClassNotFoundException {
        return this.load(null, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object load(String dirName, String name) throws IOException, ClassNotFoundException {
        byte[] buf = this.loadByteArray(dirName, name);
        if (buf != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(buf);
            ResolverObjectInputStream ois = new ResolverObjectInputStream(bis);
            try {
                Object object = ois.readObject();
                return object;
            }
            finally {
                ois.close();
                bis.close();
            }
        }
        return null;
    }

    @Override
    public final byte[] loadByteArray(String name) throws IOException {
        return this.loadByteArray(null, name);
    }

    @Override
    public final void delete(String name) {
        this.delete(null, name);
    }

    @Override
    public synchronized void release() throws IOException {
        if (this.phase != 2 && this.phase != 3 && this.phase != 4) {
            throw new IllegalStateException("Can not release transaction.");
        }
        this.setPhase(1);
        this.notify();
    }

    protected class Context {
        Hashtable log = new Hashtable(15);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(256);
        ObjectOutputStream oos = null;

        Context() {
        }
    }
}

