/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.util.AbstractTransaction;
import fr.dyade.aaa.util.DBOperation;
import fr.dyade.aaa.util.DBTransactionMBean;
import fr.dyade.aaa.util.Transaction;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class DBTransaction
extends AbstractTransaction
implements DBTransactionMBean {
    protected static Logger logmon = null;
    File dir = null;
    static int LogThresholdOperation = 1000;
    long startTime = 0L;
    protected Connection conn = null;
    private PreparedStatement insertStmt = null;
    private PreparedStatement updateStmt = null;
    private PreparedStatement deleteStmt = null;

    @Override
    public int getLogThresholdOperation() {
        return LogThresholdOperation;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String path) throws IOException {
        this.phase = 0;
        logmon = Debug.getLogger((String)Transaction.class.getName());
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, init()");
        }
        this.dir = new File(path);
        if (!this.dir.exists()) {
            this.dir.mkdir();
        }
        if (!this.dir.isDirectory()) {
            throw new FileNotFoundException(path + " is not a directory.");
        }
        FilterOutputStream ldos = null;
        try {
            File tfc = new File(this.dir, "TFC");
            if (!tfc.exists()) {
                ldos = new DataOutputStream(new FileOutputStream(tfc));
                ((DataOutputStream)ldos).writeUTF(this.getClass().getName());
                ((DataOutputStream)ldos).flush();
            }
        }
        finally {
            if (ldos != null) {
                ldos.close();
            }
        }
        this.initDB();
        try {
            this.insertStmt = this.conn.prepareStatement("INSERT INTO JoramDB VALUES (?, ?)");
            this.updateStmt = this.conn.prepareStatement("UPDATE JoramDB SET content=? WHERE name=?");
            this.deleteStmt = this.conn.prepareStatement("DELETE FROM JoramDB WHERE name=?");
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw new IOException(sqle.getMessage());
        }
        this.perThreadContext = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new AbstractTransaction.Context();
            }
        };
        this.startTime = System.currentTimeMillis();
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)("DBTransaction, initialized " + this.startTime));
        }
        this.setPhase(1);
    }

    protected abstract void initDB() throws IOException;

    public String getPersistenceDir() {
        return this.dir.getPath();
    }

    @Override
    protected final void setPhase(int newPhase) {
        this.phase = newPhase;
    }

    @Override
    public final synchronized String[] getList(String prefix) {
        try {
            Statement s = this.conn.createStatement();
            ResultSet rs = s.executeQuery("SELECT name FROM JoramDB WHERE name LIKE '" + prefix + "%'");
            Vector<String> v = new Vector<String>();
            while (rs.next()) {
                v.add(rs.getString(1));
            }
            rs.close();
            s.close();
            String[] result = new String[v.size()];
            result = v.toArray(result);
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, getList: " + v));
            }
            return result;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    final String fname(String dirName, String name) {
        if (dirName == null) {
            return name;
        }
        return new StringBuffer(dirName).append('/').append(name).toString();
    }

    @Override
    protected final void saveInLog(byte[] buf, String dirName, String name, Hashtable log, boolean copy, boolean first) throws IOException {
        String fname = this.fname(dirName, name);
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, saveInLog(" + fname + ", " + copy + ", " + first + ")"));
        }
        DBOperation op = DBOperation.alloc(1, fname, buf);
        DBOperation old = log.put(fname, op);
        if (copy) {
            op.value = old != null && old.type == 1 && old.value.length == buf.length ? old.value : new byte[buf.length];
            System.arraycopy(buf, 0, op.value, 0, buf.length);
        }
        if (old != null) {
            old.free();
        }
    }

    @Override
    public byte[] loadByteArray(String dirName, String name) throws IOException {
        Hashtable log;
        DBOperation op;
        String fname = this.fname(dirName, name);
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, loadByteArray(" + fname + ")"));
        }
        if ((op = (DBOperation)(log = ((AbstractTransaction.Context)this.perThreadContext.get()).log).get(fname)) != null) {
            if (op.type == 1) {
                return op.value;
            }
            if (op.type == 2) {
                return null;
            }
        }
        try {
            Statement s = this.conn.createStatement();
            ResultSet rs = s.executeQuery("SELECT content FROM JoramDB WHERE name='" + name + "'");
            if (!rs.next()) {
                return null;
            }
            byte[] content = rs.getBytes(1);
            rs.close();
            s.close();
            return content;
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
    }

    @Override
    public void delete(String dirName, String name) {
        String fname = this.fname(dirName, name);
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, delete(" + fname + ")"));
        }
        Hashtable log = ((AbstractTransaction.Context)this.perThreadContext.get()).log;
        DBOperation op = DBOperation.alloc(2, fname);
        if ((op = log.put(fname, op)) != null) {
            op.free();
        }
    }

    @Override
    public final synchronized void commit(boolean release) throws IOException {
        Hashtable log;
        if (this.phase != 2) {
            throw new IllegalStateException("Can not commit.");
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"DBTransaction, commit");
        }
        if (!(log = ((AbstractTransaction.Context)this.perThreadContext.get()).log).isEmpty()) {
            DBOperation op = null;
            Enumeration e = log.elements();
            while (e.hasMoreElements()) {
                op = (DBOperation)e.nextElement();
                if (op.type == 1) {
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, commit.save (" + op.name + ')'));
                    }
                    try {
                        this.insertStmt.setString(1, op.name);
                        this.insertStmt.setBytes(2, op.value);
                        this.insertStmt.executeUpdate();
                    }
                    catch (SQLException sqle1) {
                        try {
                            this.updateStmt.setBytes(1, op.value);
                            this.updateStmt.setString(2, op.name);
                            this.updateStmt.executeUpdate();
                        }
                        catch (SQLException sqle) {
                            throw new IOException(sqle.getMessage());
                        }
                    }
                } else if (op.type == 2) {
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, commit.delete (" + op.name + ')'));
                    }
                    try {
                        this.deleteStmt.setString(1, op.name);
                        this.deleteStmt.executeUpdate();
                    }
                    catch (SQLException sqle) {
                        throw new IOException(sqle.getMessage());
                    }
                }
                op.free();
            }
            log.clear();
            try {
                this.conn.commit();
            }
            catch (SQLException sqle) {
                throw new IOException(sqle.getMessage());
            }
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"DBTransaction, committed");
        }
        if (release) {
            this.setPhase(1);
            this.notify();
        } else {
            this.setPhase(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, stops");
        }
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException exc) {}
        }
        this.setPhase(6);
        try {
            Statement s = this.conn.createStatement();
            this.conn.commit();
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, TBR stop#3");
            s.executeUpdate("SHUTDOWN COMPACT");
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, TBR stop#4");
            s.close();
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, TBR stop#5");
        }
        catch (SQLException sqle) {
            logmon.log(BasicLevel.ERROR, (Object)"DBTransaction, stop#6", (Throwable)sqle);
        }
        catch (Throwable t) {
            logmon.log(BasicLevel.ERROR, (Object)"DBTransaction, stop#7", t);
        }
        finally {
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, stop#8");
        }
        logmon.log(BasicLevel.INFO, (Object)"DBTransaction, TBR stop#9");
        this.setPhase(1);
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"NTransaction, stopped: ");
        }
    }

    @Override
    public synchronized void close() {
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, close");
        }
        if (this.phase == 0) {
            return;
        }
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException exc) {}
        }
        this.setPhase(6);
        try {
            Statement s = this.conn.createStatement();
            s.execute("SHUTDOWN COMPACT");
            s.close();
        }
        catch (SQLException sqle) {
            logmon.log(BasicLevel.ERROR, (Object)"DBTransaction, close", (Throwable)sqle);
        }
        this.setPhase(0);
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, closed: ");
        }
    }
}

