/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.util.DBTransaction;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;
import org.objectweb.util.monolog.api.BasicLevel;

public final class MySQLDBTransaction
extends DBTransaction {
    private String driver = "com.mysql.jdbc.Driver";
    private String connurl = "jdbc:mysql:";

    @Override
    protected void initDB() throws IOException {
        block11: {
            Properties prop;
            block10: {
                String configFile = System.getProperty("MySQLDBTransactionConfigFile", "MySQL.properties");
                prop = new Properties();
                try {
                    prop.load(new FileInputStream(configFile));
                }
                catch (FileNotFoundException e) {
                    if (!logmon.isLoggable(BasicLevel.INFO)) break block10;
                    logmon.log(BasicLevel.INFO, (Object)("File " + configFile + " not found, using default parameters"));
                }
            }
            String dbHost = prop.getProperty("host", "localhost");
            String dbPort = prop.getProperty("port", "3306");
            String dbName = prop.getProperty("database", "joramdb");
            String dbUser = prop.getProperty("user", "joram");
            String dbPass = prop.getProperty("password", "joram");
            try {
                Class.forName(this.driver).newInstance();
                StringBuffer sb = new StringBuffer(this.connurl);
                sb.append("//");
                sb.append(dbHost);
                sb.append(':');
                sb.append(dbPort);
                sb.append('/');
                sb.append(dbName);
                sb.append("?user=");
                sb.append(dbUser);
                sb.append("&password=");
                sb.append(dbPass);
                Enumeration<Object> enu = prop.keys();
                while (enu.hasMoreElements()) {
                    String key = (String)enu.nextElement();
                    if (key.equals("host") || key.equals("port") || key.equals("database") || key.equals("user") || key.equals("password")) continue;
                    sb.append('&');
                    sb.append(key);
                    sb.append('=');
                    sb.append(prop.get(key));
                }
                this.conn = DriverManager.getConnection(sb.toString());
                this.conn.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
            catch (InstantiationException e) {
                throw new IOException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IOException(e.getMessage());
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e.getMessage());
            }
            try {
                Statement s = this.conn.createStatement();
                s.execute("CREATE TABLE JoramDB (name VARCHAR(256), content LONGBLOB, PRIMARY KEY(name))");
                s.close();
                this.conn.commit();
            }
            catch (SQLException sqle) {
                if (!logmon.isLoggable(BasicLevel.INFO)) break block11;
                logmon.log(BasicLevel.INFO, (Object)"DBTransaction, init() DB already exists");
            }
        }
    }
}

