/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.common.Configuration;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.Pool;
import fr.dyade.aaa.util.AbstractTransaction;
import fr.dyade.aaa.util.NGTransactionMBean;
import fr.dyade.aaa.util.Operation;
import fr.dyade.aaa.util.OperationKey;
import fr.dyade.aaa.util.Repository;
import fr.dyade.aaa.util.StartWithFilter;
import fr.dyade.aaa.util.Transaction;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class NGTransaction
extends AbstractTransaction
implements NGTransactionMBean {
    private static Logger logmon = null;
    static int LogMemoryCapacity = 4096;
    static int MaxLogFileSize = 0x1000000;
    static int LogThresholdOperation = 1000;
    String repositoryImpl = "fr.dyade.aaa.util.FileRepository";
    long startTime = 0L;
    File dir = null;
    LogManager logManager = null;
    Repository repository = null;

    @Override
    public final int getLogMemoryCapacity() {
        return LogMemoryCapacity;
    }

    @Override
    public int getLogMemorySize() {
        return this.logManager.log.size();
    }

    @Override
    public final int getMaxLogFileSize() {
        return MaxLogFileSize / 0x100000;
    }

    @Override
    public final void setMaxLogFileSize(int size) {
        if (size > 0) {
            MaxLogFileSize = size * 0x100000;
        }
    }

    @Override
    public final int getLogFileSize() {
        return this.logManager.getLogFileSize() / 1024;
    }

    @Override
    public final int getNbLogFiles() {
        return this.logManager.nbLogFile;
    }

    @Override
    public final int getLogThresholdOperation() {
        return LogThresholdOperation;
    }

    @Override
    public final int getCommitCount() {
        return this.logManager.commitCount;
    }

    @Override
    public final int getGarbageCount() {
        return this.logManager.garbageCount;
    }

    @Override
    public long getGarbageTime() {
        return this.logManager.garbageTime;
    }

    @Override
    public int getNbLoadedFromLog() {
        return this.logManager.loadFromLog;
    }

    @Override
    public int getGarbageRatio() {
        return (int)(this.logManager.garbageTime * 100L / (System.currentTimeMillis() - this.startTime));
    }

    @Override
    public String getRepositoryImpl() {
        return this.repositoryImpl;
    }

    @Override
    public int getNbSavedObjects() {
        return this.repository.getNbSavedObjects();
    }

    @Override
    public int getNbDeletedObjects() {
        return this.repository.getNbDeletedObjects();
    }

    @Override
    public int getNbBadDeletedObjects() {
        return this.repository.getNbBadDeletedObjects();
    }

    @Override
    public int getNbLoadedObjects() {
        return this.repository.getNbLoadedObjects();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void init(String path) throws IOException {
        this.phase = 0;
        logmon = Debug.getLogger(Transaction.class.getName());
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"NTransaction, init():");
        }
        LogMemoryCapacity = Configuration.getInteger("NTLogMemoryCapacity", LogMemoryCapacity);
        MaxLogFileSize = Configuration.getInteger("NTLogFileSize", MaxLogFileSize / 0x100000) * 0x100000;
        LogThresholdOperation = Configuration.getInteger("NTLogThresholdOperation", LogThresholdOperation);
        Operation.pool = new Pool("NGTransaction$Operation", LogThresholdOperation);
        this.dir = new File(path);
        if (!this.dir.exists()) {
            this.dir.mkdir();
        }
        if (!this.dir.isDirectory()) {
            throw new FileNotFoundException(path + " is not a directory.");
        }
        FilterOutputStream ldos = null;
        try {
            File tfc = new File(this.dir, "TFC");
            if (!tfc.exists()) {
                ldos = new DataOutputStream(new FileOutputStream(tfc));
                ((DataOutputStream)ldos).writeUTF(this.getClass().getName());
                ((DataOutputStream)ldos).flush();
            }
        }
        finally {
            if (ldos != null) {
                ldos.close();
            }
        }
        try {
            this.repositoryImpl = System.getProperty("NTRepositoryImpl", this.repositoryImpl);
            this.repository = (Repository)Class.forName(this.repositoryImpl).newInstance();
            this.repository.init(this.dir);
        }
        catch (ClassNotFoundException exc) {
            logmon.log(BasicLevel.FATAL, (Object)"NTransaction, cannot initializes the repository ", (Throwable)exc);
            throw new IOException(exc.getMessage());
        }
        catch (InstantiationException exc) {
            logmon.log(BasicLevel.FATAL, (Object)"NTransaction, cannot initializes the repository ", (Throwable)exc);
            throw new IOException(exc.getMessage());
        }
        catch (IllegalAccessException exc) {
            logmon.log(BasicLevel.FATAL, (Object)"NTransaction, cannot initializes the repository ", (Throwable)exc);
            throw new IOException(exc.getMessage());
        }
        this.logManager = new LogManager(this.dir, this.repository);
        this.perThreadContext = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new AbstractTransaction.Context();
            }
        };
        this.startTime = System.currentTimeMillis();
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)("NTransaction, initialized " + this.startTime));
        }
        this.setPhase(1);
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    public String getPersistenceDir() {
        return this.dir.getPath();
    }

    @Override
    protected final void setPhase(int newPhase) {
        this.phase = newPhase;
    }

    @Override
    public synchronized String[] getList(String prefix) {
        return this.logManager.getList(prefix);
    }

    @Override
    protected final void saveInLog(byte[] buf, String dirName, String name, Hashtable log, boolean copy, boolean first) throws IOException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("NGTransaction, saveInLog(" + dirName + '/' + name + ", " + copy + ", " + first + ")"));
        }
        Object key = OperationKey.newKey(dirName, name);
        Operation op = null;
        op = first ? Operation.alloc(4, dirName, name, buf) : Operation.alloc(1, dirName, name, buf);
        Operation old = log.put(key, op);
        if (copy) {
            op.value = old != null && old.type == 1 && old.value.length == buf.length ? old.value : new byte[buf.length];
            System.arraycopy(buf, 0, op.value, 0, buf.length);
        }
        if (old != null) {
            old.free();
        }
    }

    private final byte[] getFromLog(Hashtable log, Object key) throws IOException {
        Operation op = (Operation)log.get(key);
        if (op != null) {
            if (op.type == 1 || op.type == 4) {
                return op.value;
            }
            if (op.type == 2) {
                throw new FileNotFoundException();
            }
        }
        return null;
    }

    private final synchronized byte[] getFromLog(String dirName, String name) throws IOException {
        Object key = OperationKey.newKey(dirName, name);
        byte[] buf = this.getFromLog(((AbstractTransaction.Context)this.perThreadContext.get()).log, key);
        if (buf != null) {
            return buf;
        }
        return this.logManager.load(dirName, name);
    }

    @Override
    public byte[] loadByteArray(String dirName, String name) throws IOException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, loadByteArray(" + dirName + '/' + name + ")"));
        }
        try {
            return this.getFromLog(dirName, name);
        }
        catch (FileNotFoundException exc) {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, loadByteArray(" + dirName + '/' + name + ") not found"));
            }
            return null;
        }
    }

    @Override
    public final void delete(String dirName, String name) {
        Operation op;
        Object key;
        Hashtable log;
        Operation old;
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, delete(" + dirName + ", " + name + ")"));
        }
        if ((old = (log = ((AbstractTransaction.Context)this.perThreadContext.get()).log).put(key = OperationKey.newKey(dirName, name), op = Operation.alloc(2, dirName, name))) != null) {
            if (old.type == 4) {
                op.type = 5;
            }
            old.free();
        }
    }

    @Override
    public final synchronized void commit(boolean release) throws IOException {
        Hashtable log;
        if (this.phase != 2) {
            throw new IllegalStateException("Can not commit.");
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"NTransaction, commit");
        }
        if (!(log = ((AbstractTransaction.Context)this.perThreadContext.get()).log).isEmpty()) {
            this.logManager.commit(log);
            log.clear();
        }
        if (release) {
            this.setPhase(1);
            this.notify();
        } else {
            this.setPhase(3);
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"NTransaction, committed");
        }
    }

    @Override
    public synchronized void stop() {
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"NTransaction, stops");
        }
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException exc) {}
        }
        this.setPhase(6);
        try {
            this.logManager.garbage();
        }
        catch (IOException exc) {
            logmon.log(BasicLevel.WARN, (Object)"NTransaction, can't garbage log files", (Throwable)exc);
        }
        this.setPhase(1);
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)("NTransaction, stopped: " + this.toString()));
        }
    }

    @Override
    public synchronized void close() {
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"NTransaction, closes");
        }
        if (this.phase == 0) {
            return;
        }
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setPhase(6);
        this.logManager.stop();
        this.setPhase(0);
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)("NTransaction, closed: " + this.toString()));
        }
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append('(').append(super.toString());
        strbuf.append(",LogMemorySize=").append(this.getLogMemorySize());
        strbuf.append(",LogFileSize=").append(this.getLogFileSize());
        strbuf.append(",CommitCount=").append(this.getCommitCount());
        strbuf.append(",GarbageCount=").append(this.getGarbageCount());
        strbuf.append(",GarbageRatio=").append(this.getGarbageRatio());
        strbuf.append(",NbLoadedFromLog=").append(this.getNbLoadedFromLog());
        strbuf.append(",NbSavedObjects=").append(this.getNbSavedObjects());
        strbuf.append(",NbDeletedObjects=").append(this.getNbDeletedObjects());
        strbuf.append(",NbBadDeletedObjects=").append(this.getNbBadDeletedObjects());
        strbuf.append(",NbLoadedObjects=").append(this.getNbLoadedObjects());
        strbuf.append(')');
        return strbuf.toString();
    }

    public static class LogFile
    extends RandomAccessFile {
        int logidx;
        int logCounter = 0;
        File dir;

        public LogFile(File dir, int logidx) throws FileNotFoundException {
            super(new File(dir, "log#" + logidx), "rwd");
            this.logidx = logidx;
            this.dir = dir;
        }

        public void renameTo(int newidx) {
            new File(this.dir, "log#" + this.logidx).renameTo(new File(this.dir, "log#" + newidx));
        }
    }

    static final class LogManager
    extends ByteArrayOutputStream {
        Hashtable<Object, Operation> log = null;
        int nbLogFile = 4;
        int logidx;
        LogFile[] logFile = null;
        int current = -1;
        int commitCount = 0;
        int loadFromLog = 0;
        int garbageCount = 0;
        long garbageTime = 0L;
        long lastGarbageTime = 0L;
        private Repository repository = null;
        File dir;
        private static final byte[] emptyUTFString = new byte[]{0, 0};

        int getLogFileSize() {
            return this.current;
        }

        LogManager(File dir, Repository repository) throws IOException {
            super(4096);
            this.repository = repository;
            this.log = new Hashtable(LogMemoryCapacity);
            long start = System.currentTimeMillis();
            this.logidx = -1;
            this.logFile = new LogFile[this.nbLogFile];
            this.dir = dir;
            Object[] list = dir.list(new StartWithFilter("log#"));
            if (list == null) {
                throw new IOException("NGTransaction error opening " + dir.getAbsolutePath());
            }
            if (list.length == 0) {
                this.logidx = 0;
            } else {
                Arrays.sort(list);
                for (int i = 0; i < list.length; ++i) {
                    logmon.log(BasicLevel.WARN, (Object)("NGTransaction.LogManager, rebuilds index: " + (String)list[i]));
                    int idx = Integer.parseInt(((String)list[i]).substring(4));
                    if (this.logidx == -1) {
                        this.logidx = idx;
                    }
                    LogFile logf = new LogFile(dir, idx);
                    int optype = logf.read();
                    if (optype == 127) {
                        logf.close();
                        continue;
                    }
                    this.logidx = idx;
                    this.logFile[this.logidx % this.nbLogFile] = logf;
                    while (optype == 3) {
                        optype = this.logFile[this.logidx % this.nbLogFile].read();
                        while (optype == 4 || optype == 1 || optype == 2) {
                            Operation old;
                            int ptr = (int)this.logFile[this.logidx % this.nbLogFile].getFilePointer() - 1;
                            ++this.logFile[this.logidx % this.nbLogFile].logCounter;
                            String dirName = this.logFile[this.logidx % this.nbLogFile].readUTF();
                            if (dirName.length() == 0) {
                                dirName = null;
                            }
                            String name = this.logFile[this.logidx % this.nbLogFile].readUTF();
                            Object key = OperationKey.newKey(dirName, name);
                            byte[] buf = null;
                            if (optype == 1 || optype == 4) {
                                buf = new byte[this.logFile[this.logidx % this.nbLogFile].readInt()];
                                this.logFile[this.logidx % this.nbLogFile].readFully(buf);
                            }
                            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                                logmon.log(BasicLevel.DEBUG, (Object)("NGTransaction.LogManager, OPERATION=" + optype + ", " + name + " buf=" + Arrays.toString(buf)));
                            }
                            if ((old = this.log.get(key)) != null) {
                                --this.logFile[old.logidx % this.nbLogFile].logCounter;
                                if (old.type == 4 || old.type == 1) {
                                    if (optype == 4 || optype == 1) {
                                        old.logidx = this.logidx;
                                        old.logptr = ptr;
                                    } else if (old.type == 4) {
                                        old.type = 5;
                                        this.log.remove(key);
                                        old.free();
                                        --this.logFile[this.logidx % this.nbLogFile].logCounter;
                                    } else {
                                        old.type = 2;
                                        old.logidx = this.logidx;
                                        old.logptr = ptr;
                                    }
                                } else if (old.type == 2) {
                                    if (optype == 4 || optype == 1) {
                                        old.type = 1;
                                    }
                                    old.logidx = this.logidx;
                                    old.logptr = ptr;
                                }
                            } else {
                                Operation op = Operation.alloc(optype, dirName, name);
                                op.logidx = this.logidx;
                                op.logptr = ptr;
                                this.log.put(key, op);
                            }
                            optype = this.logFile[this.logidx % this.nbLogFile].read();
                        }
                        if (!logmon.isLoggable(BasicLevel.DEBUG)) continue;
                        logmon.log(BasicLevel.DEBUG, (Object)("NGTransaction.LogManager, COMMIT#" + idx));
                    }
                    this.current = (int)this.logFile[this.logidx % this.nbLogFile].getFilePointer();
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.DEBUG, (Object)("NGTransaction.LogManager, END#" + this.logidx));
                    }
                    if (optype == 127) continue;
                    throw new IOException("Corrupted transaction log#" + this.logidx);
                }
                logmon.log(BasicLevel.DEBUG, (Object)("NGTransaction.LogManager, log=" + Arrays.toString(this.log.values().toArray())));
            }
            if (this.logFile[this.logidx % this.nbLogFile] == null) {
                this.logFile[this.logidx % this.nbLogFile] = new LogFile(dir, this.logidx);
                this.logFile[this.logidx % this.nbLogFile].setLength(MaxLogFileSize);
                this.logFile[this.logidx % this.nbLogFile].seek(0L);
                this.logFile[this.logidx % this.nbLogFile].write(127);
                this.current = 1;
            }
            logmon.log(BasicLevel.INFO, (Object)("NGTransaction.LogManager, ends: " + (System.currentTimeMillis() - start)));
        }

        void commit(Hashtable<Object, Operation> ctxlog) throws IOException {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)"NTransaction.LogFile.commit()");
            }
            ++this.commitCount;
            Set<Map.Entry<Object, Operation>> entries = ctxlog.entrySet();
            Iterator<Map.Entry<Object, Operation>> iterator = entries.iterator();
            try {
                while (true) {
                    Map.Entry<Object, Operation> entry = iterator.next();
                    Object key = entry.getKey();
                    Operation op = entry.getValue();
                    if (op.type == 5) continue;
                    op.logidx = this.logidx;
                    op.logptr = this.current + this.count;
                    this.write(op.type);
                    if (op.dirName != null) {
                        this.writeUTF(op.dirName);
                    } else {
                        this.write(emptyUTFString);
                    }
                    this.writeUTF(op.name);
                    if (op.type == 1 || op.type == 4) {
                        this.writeInt(op.value.length);
                        this.write(op.value);
                    }
                    op.value = null;
                    Operation old = this.log.put(key, op);
                    ++this.logFile[this.logidx % this.nbLogFile].logCounter;
                    if (old == null) continue;
                    --this.logFile[old.logidx % this.nbLogFile].logCounter;
                    if (old.type == 4) {
                        if (op.type == 1) {
                            op.type = 4;
                        } else if (op.type == 2) {
                            op.type = 5;
                            this.log.remove(key);
                            op.free();
                            --this.logFile[this.logidx % this.nbLogFile].logCounter;
                        }
                    }
                    old.free();
                }
            }
            catch (NoSuchElementException exc) {
                int i;
                this.write(127);
                this.logFile[this.logidx % this.nbLogFile].seek(this.current);
                this.logFile[this.logidx % this.nbLogFile].write(this.buf, 0, this.count);
                this.logFile[this.logidx % this.nbLogFile].seek(this.current - 1);
                this.logFile[this.logidx % this.nbLogFile].write(3);
                this.current += this.count;
                this.reset();
                ctxlog.clear();
                for (i = 0; i < this.nbLogFile; ++i) {
                    if (this.logFile[i] == null || this.logFile[i].logCounter != 0) continue;
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.DEBUG, (Object)("NTransaction log#" + this.logFile[i].logidx + " is no longer needed, cleans it."));
                    }
                    this.garbage(this.logFile[i]);
                }
                if (this.current > MaxLogFileSize) {
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        for (i = 0; i < this.nbLogFile; ++i) {
                            if (this.logFile[i] == null) continue;
                            logmon.log(BasicLevel.DEBUG, (Object)("logCounter[" + this.logFile[i].logidx + "]=" + this.logFile[i].logCounter));
                        }
                        logmon.log(BasicLevel.DEBUG, (Object)("log -> " + this.log.size()));
                    }
                    ++this.logidx;
                    if (this.logFile[this.logidx % this.nbLogFile] != null) {
                        this.garbage(this.logFile[this.logidx % this.nbLogFile]);
                    }
                    this.logFile[this.logidx % this.nbLogFile] = new LogFile(this.dir, this.logidx);
                    this.logFile[this.logidx % this.nbLogFile].setLength(MaxLogFileSize);
                    this.logFile[this.logidx % this.nbLogFile].seek(0L);
                    this.logFile[this.logidx % this.nbLogFile].write(127);
                    this.current = 1;
                }
                return;
            }
        }

        public byte[] getFromLog(String dirName, String name) throws IOException {
            Operation op = this.log.get(OperationKey.newKey(dirName, name));
            if (op != null) {
                if (op.type == 1 || op.type == 4) {
                    return this.getFromLog(op);
                }
                if (op.type == 2) {
                    throw new FileNotFoundException();
                }
            }
            return null;
        }

        public byte[] getFromLog(Operation op) throws IOException {
            String dirName;
            ++this.loadFromLog;
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("getFromLog#" + op.logidx + ' ' + op.dirName + '/' + op.name + ": " + op.logptr));
            }
            this.logFile[op.logidx % this.nbLogFile].seek(op.logptr);
            int optype = this.logFile[op.logidx % this.nbLogFile].read();
            if (optype != 4 && optype != 1 && logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("getFromLog#" + op.logidx + ": " + optype + ", " + op.type));
            }
            if ((dirName = this.logFile[op.logidx % this.nbLogFile].readUTF()).length() == 0) {
                dirName = null;
            }
            String name = this.logFile[op.logidx % this.nbLogFile].readUTF();
            if (dirName != null && !dirName.equals(op.dirName) || !name.equals(op.name) && logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("getFromLog#" + op.logidx + ": " + dirName + '/' + name + ", " + op.dirName + '/' + op.name));
            }
            byte[] buf = new byte[this.logFile[op.logidx % this.nbLogFile].readInt()];
            this.logFile[op.logidx % this.nbLogFile].readFully(buf);
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("getFromLog#" + op.logidx + ", buf=" + Arrays.toString(buf)));
            }
            return buf;
        }

        public byte[] load(String dirName, String name) throws IOException {
            byte[] buf = this.getFromLog(dirName, name);
            if (buf == null) {
                buf = this.repository.load(dirName, name);
            }
            return buf;
        }

        public String[] getList(String prefix) {
            int i;
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("getList(" + prefix + ")"));
            }
            String[] list1 = null;
            try {
                list1 = this.repository.list(prefix);
            }
            catch (IOException exc) {
                // empty catch block
            }
            if (list1 == null) {
                list1 = new String[]{};
            }
            Object[] list2 = this.log.keySet().toArray();
            int nb = list1.length;
            for (int i2 = 0; i2 < list2.length; ++i2) {
                if (list2[i2] instanceof String && ((String)list2[i2]).startsWith(prefix)) {
                    int j;
                    for (j = 0; j < list1.length && !list2[i2].equals(list1[j]); ++j) {
                    }
                    if (j < list1.length) {
                        if (this.log.get((Object)list2[i2]).type == 2) {
                            list1[j] = null;
                            --nb;
                        }
                        list2[i2] = null;
                        continue;
                    }
                    if (this.log.get((Object)list2[i2]).type == 1 || this.log.get((Object)list2[i2]).type == 4) {
                        ++nb;
                        continue;
                    }
                    list2[i2] = null;
                    continue;
                }
                list2[i2] = null;
            }
            Object[] list = new String[nb];
            for (i = list1.length - 1; i >= 0; --i) {
                if (list1[i] == null) continue;
                list[--nb] = list1[i];
            }
            for (i = list2.length - 1; i >= 0; --i) {
                if (list2[i] == null) continue;
                list[--nb] = (String)list2[i];
            }
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("getList() -> " + Arrays.toString(list)));
            }
            return list;
        }

        private final void garbage() throws IOException {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("log -> " + this.log.size()));
                for (int i = 0; i < this.logFile.length; ++i) {
                    if (this.logFile[i] == null) continue;
                    logmon.log(BasicLevel.FATAL, (Object)("logCounter[" + this.logFile[i].logidx + "]=" + this.logFile[i].logCounter));
                }
                Enumeration<Operation> e = this.log.elements();
                while (e.hasMoreElements()) {
                    Operation op = e.nextElement();
                    logmon.log(BasicLevel.DEBUG, (Object)op);
                }
            }
            for (int i = 0; i < this.nbLogFile; ++i) {
                this.garbage(this.logFile[i]);
            }
        }

        private final void garbage(LogFile logf) throws IOException {
            long end;
            if (logf == null) {
                return;
            }
            ++this.garbageCount;
            long start = System.currentTimeMillis();
            if (logf.logCounter > 0) {
                Iterator<Operation> iterator = this.log.values().iterator();
                try {
                    while (true) {
                        Operation op = iterator.next();
                        if (op.logidx != logf.logidx) continue;
                        if (op.type == 1 || op.type == 4) {
                            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                                logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, LogFile.Save (" + op.dirName + '/' + op.name + ')'));
                            }
                            byte[] buf = this.getFromLog(op);
                            this.repository.save(op.dirName, op.name, buf);
                        } else if (op.type == 2) {
                            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                                logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, LogFile.Delete (" + op.dirName + '/' + op.name + ')'));
                            }
                            this.repository.delete(op.dirName, op.name);
                        }
                        iterator.remove();
                        op.free();
                    }
                }
                catch (NoSuchElementException exc) {
                    this.repository.commit();
                }
            }
            logf.seek(0L);
            logf.write(127);
            if (logf.logidx == this.logidx) {
                this.current = 1;
            } else {
                logf.close();
                logf.renameTo(logf.logidx + this.nbLogFile);
                this.logFile[logf.logidx % this.nbLogFile] = null;
            }
            this.lastGarbageTime = end = System.currentTimeMillis();
            this.garbageTime += end - start;
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("NTransaction.LogFile.garbage() - end: " + (end - start)));
            }
        }

        void stop() {
            try {
                this.garbage();
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                for (int i = 0; i < this.logFile.length; ++i) {
                    if (this.logFile[i] == null) continue;
                    logmon.log(BasicLevel.DEBUG, (Object)("logCounter[" + i + "]=" + this.logFile[i].logCounter));
                }
                logmon.log(BasicLevel.DEBUG, (Object)("log -> " + this.log.size()));
                Enumeration<Operation> e = this.log.elements();
                while (e.hasMoreElements()) {
                    logmon.log(BasicLevel.DEBUG, (Object)e.nextElement());
                }
            }
        }

        void writeUTF(String str) {
            int strlen = str.length();
            int newcount = this.count + strlen + 2;
            if (newcount > this.buf.length) {
                byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
                System.arraycopy(this.buf, 0, newbuf, 0, this.count);
                this.buf = newbuf;
            }
            this.buf[this.count++] = (byte)(strlen >>> 8 & 0xFF);
            this.buf[this.count++] = (byte)(strlen >>> 0 & 0xFF);
            str.getBytes(0, strlen, this.buf, this.count);
            this.count = newcount;
        }

        void writeInt(int v) throws IOException {
            int newcount = this.count + 4;
            if (newcount > this.buf.length) {
                byte[] newbuf = new byte[this.buf.length << 1];
                System.arraycopy(this.buf, 0, newbuf, 0, this.count);
                this.buf = newbuf;
            }
            this.buf[this.count++] = (byte)(v >>> 24 & 0xFF);
            this.buf[this.count++] = (byte)(v >>> 16 & 0xFF);
            this.buf[this.count++] = (byte)(v >>> 8 & 0xFF);
            this.buf[this.count++] = (byte)(v >>> 0 & 0xFF);
        }
    }
}

