/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.objectweb.joram.shared.admin.Monitor_Reply;
import org.objectweb.joram.shared.stream.StreamUtil;

public class Monitor_GetStatRep
extends Monitor_Reply {
    private static final long serialVersionUID = 1L;
    private Hashtable stats;

    public Monitor_GetStatRep(Hashtable stats) {
        this.stats = stats;
    }

    public Monitor_GetStatRep() {
    }

    public Hashtable getStats() {
        return this.stats;
    }

    @Override
    protected int getClassId() {
        return 56;
    }

    @Override
    public void readFrom(InputStream is) throws IOException {
        super.readFrom(is);
        int size = StreamUtil.readIntFrom(is);
        if (size == -1) {
            this.stats = null;
        } else {
            this.stats = new Hashtable(size * 4 / 3);
            for (int i = 0; i < size; ++i) {
                String key = StreamUtil.readStringFrom(is);
                long value = StreamUtil.readLongFrom(is);
                this.stats.put(key, new Long(value));
            }
        }
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        super.writeTo(os);
        if (this.stats == null) {
            StreamUtil.writeTo(-1, os);
        } else {
            int size = this.stats.size();
            StreamUtil.writeTo(size, os);
            Enumeration keys = this.stats.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                StreamUtil.writeTo(key, os);
                long value = (Long)this.stats.get(key);
                StreamUtil.writeTo(value, os);
            }
        }
    }
}

