/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared.client;

import fr.dyade.aaa.common.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Hashtable;
import org.objectweb.joram.shared.stream.StreamUtil;
import org.objectweb.joram.shared.stream.Streamable;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class AbstractJmsMessage
implements Externalizable,
Streamable {
    public static Logger logger = Debug.getLogger(AbstractJmsMessage.class.getName());
    protected static final int NULL_CLASS_ID = -1;
    protected static final int CNX_CONNECT_REQUEST = 0;
    protected static final int CNX_CONNECT_REPLY = 1;
    protected static final int CNX_START_REQUEST = 2;
    protected static final int CNX_STOP_REQUEST = 3;
    protected static final int CNX_CLOSE_REQUEST = 4;
    protected static final int CNX_CLOSE_REPLY = 5;
    protected static final int PRODUCER_MESSAGES = 6;
    protected static final int CONSUMER_RECEIVE_REQUEST = 7;
    protected static final int CONSUMER_MESSAGES = 8;
    protected static final int CONSUMER_SUB_REQUEST = 9;
    protected static final int CONSUMER_UNSUB_REQUEST = 10;
    protected static final int CONSUMER_ACK_REQUEST = 11;
    protected static final int CONSUMER_DENY_REQUEST = 12;
    protected static final int SESS_ACK_REQUEST = 13;
    protected static final int SESS_DENY_REQUEST = 14;
    protected static final int MOM_EXCEPTION_REPLY = 15;
    protected static final int SERVER_REPLY = 16;
    protected static final int ACTIVATE_CONSUMER_REQUEST = 17;
    protected static final int COMMIT_REQUEST = 18;
    protected static final int CONSUMER_CLOSE_SUB_REQUEST = 19;
    protected static final int CONSUMER_SET_LIST_REQUEST = 20;
    protected static final int CONSUMER_UNSET_LIST_REQUEST = 21;
    protected static final int GET_ADMIN_TOPIC_REPLY = 22;
    protected static final int GET_ADMIN_TOPIC_REQUEST = 23;
    protected static final int JMS_REQUEST_GROUP = 24;
    protected static final int PING_REQUEST = 25;
    protected static final int QBROWSE_REPLY = 26;
    protected static final int QBROWSE_REQUEST = 27;
    protected static final int SESS_CREATE_TDREPLY = 28;
    protected static final int SESS_CREATE_TQREQUEST = 29;
    protected static final int SESS_CREATE_TTREQUEST = 30;
    protected static final int TEMP_DEST_DELETE_REQUEST = 31;
    protected static final int XA_CNX_COMMIT = 32;
    protected static final int XA_CNX_PREPARE = 33;
    protected static final int XA_CNX_RECOVER_REPLY = 34;
    protected static final int XA_CNX_RECOVER_REQUEST = 35;
    protected static final int XA_CNX_ROLLBACK = 36;
    protected int classid = this.getClassId();
    protected static final String[] classnames = new String[]{"org.objectweb.joram.shared.client.CnxConnectRequest", "org.objectweb.joram.shared.client.CnxConnectReply", "org.objectweb.joram.shared.client.CnxStartRequest", "org.objectweb.joram.shared.client.CnxStopRequest", "org.objectweb.joram.shared.client.CnxCloseRequest", "org.objectweb.joram.shared.client.CnxCloseReply", "org.objectweb.joram.shared.client.ProducerMessages", "org.objectweb.joram.shared.client.ConsumerReceiveRequest", "org.objectweb.joram.shared.client.ConsumerMessages", "org.objectweb.joram.shared.client.ConsumerSubRequest", "org.objectweb.joram.shared.client.ConsumerUnsubRequest", "org.objectweb.joram.shared.client.ConsumerAckRequest", "org.objectweb.joram.shared.client.ConsumerDenyRequest", "org.objectweb.joram.shared.client.SessAckRequest", "org.objectweb.joram.shared.client.SessDenyRequest", "org.objectweb.joram.shared.client.MomExceptionReply", "org.objectweb.joram.shared.client.ServerReply", "org.objectweb.joram.shared.client.ActivateConsumerRequest", "org.objectweb.joram.shared.client.CommitRequest", "org.objectweb.joram.shared.client.ConsumerCloseSubRequest", "org.objectweb.joram.shared.client.ConsumerSetListRequest", "org.objectweb.joram.shared.client.ConsumerUnsetListRequest", "org.objectweb.joram.shared.client.GetAdminTopicReply", "org.objectweb.joram.shared.client.GetAdminTopicRequest", "org.objectweb.joram.shared.client.JmsRequestGroup", "org.objectweb.joram.shared.client.PingRequest", "org.objectweb.joram.shared.client.QBrowseReply", "org.objectweb.joram.shared.client.QBrowseRequest", "org.objectweb.joram.shared.client.SessCreateTDReply", "org.objectweb.joram.shared.client.SessCreateTQRequest", "org.objectweb.joram.shared.client.SessCreateTTRequest", "org.objectweb.joram.shared.client.TempDestDeleteRequest", "org.objectweb.joram.shared.client.XACnxCommit", "org.objectweb.joram.shared.client.XACnxPrepare", "org.objectweb.joram.shared.client.XACnxRecoverReply", "org.objectweb.joram.shared.client.XACnxRecoverRequest", "org.objectweb.joram.shared.client.XACnxRollback"};

    protected abstract int getClassId();

    public Hashtable soapCode() throws IOException {
        Hashtable<String, Object> h = new Hashtable<String, Object>();
        h.put("classname", this.getClass().getName());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeTo(baos);
        baos.flush();
        h.put("bytecontent", baos.toByteArray());
        baos.close();
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object soapDecode(Hashtable h) throws Exception {
        AbstractJmsMessage msg = null;
        ByteArrayInputStream bais = null;
        String classname = (String)h.get("classname");
        msg = (AbstractJmsMessage)Class.forName(classname).newInstance();
        byte[] content = (byte[])h.get("bytecontent");
        try {
            bais = new ByteArrayInputStream(content);
            msg.readFrom(bais);
        }
        finally {
            if (bais != null) {
                bais.close();
            }
        }
        return msg;
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        this.writeTo((OutputStream)((Object)out));
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readFrom((InputStream)((Object)in));
    }

    public static void write(AbstractJmsMessage msg, OutputStream os) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AbstractJmsMessage.write: " + msg));
        }
        if (msg == null) {
            StreamUtil.writeTo(-1, os);
        } else {
            StreamUtil.writeTo(msg.getClassId(), os);
            msg.writeTo(os);
        }
    }

    public static AbstractJmsMessage read(InputStream is) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        int classid = -1;
        AbstractJmsMessage msg = null;
        classid = StreamUtil.readIntFrom(is);
        if (classid != -1) {
            msg = (AbstractJmsMessage)Class.forName(classnames[classid]).newInstance();
            msg.readFrom(is);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AbstractJmsMessage.read: " + msg));
        }
        return msg;
    }
}

