/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.stream.StreamUtil;

public final class JmsRequestGroup
extends AbstractJmsRequest {
    private static final long serialVersionUID = 1L;
    private AbstractJmsRequest[] requests;

    @Override
    protected int getClassId() {
        return 24;
    }

    public JmsRequestGroup(AbstractJmsRequest[] ajr) {
        this.requests = ajr;
    }

    public final AbstractJmsRequest[] getRequests() {
        return this.requests;
    }

    public JmsRequestGroup() {
    }

    @Override
    public void toString(StringBuffer strbuf) {
        super.toString(strbuf);
        strbuf.append(",requests.length=").append(this.requests.length);
        strbuf.append(')');
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        super.writeTo(os);
        if (this.requests == null) {
            StreamUtil.writeTo(-1, os);
        } else {
            int size = this.requests.length;
            StreamUtil.writeTo(size, os);
            for (int i = 0; i < size; ++i) {
                StreamUtil.writeTo(this.requests[i].getClass().getName(), os);
                this.requests[i].writeTo(os);
            }
        }
    }

    @Override
    public void readFrom(InputStream is) throws IOException {
        super.readFrom(is);
        int size = StreamUtil.readIntFrom(is);
        if (size == -1) {
            this.requests = null;
        } else {
            this.requests = new AbstractJmsRequest[size];
            for (int i = 0; i < size; ++i) {
                String cn = StreamUtil.readStringFrom(is);
                try {
                    this.requests[i] = (AbstractJmsRequest)Class.forName(cn).newInstance();
                }
                catch (ClassNotFoundException exc) {
                    throw new IOException("AbstractJmsRequest.readFrom(), Unknown class " + cn);
                }
                catch (InstantiationException exc) {
                    throw new IOException("AbstractJmsRequest.readFrom(), Cannot Instantiate " + cn);
                }
                catch (IllegalAccessException exc) {
                    throw new IOException("AbstractJmsRequest.readFrom(), Cannot IllegalAccessException " + cn);
                }
                this.requests[i].readFrom(is);
            }
        }
    }
}

