/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.joram.shared.stream.StreamUtil;

public final class ProducerMessages
extends AbstractJmsRequest {
    private static final long serialVersionUID = 1L;
    private Vector messages = null;
    private boolean asyncSend = false;

    public void setAsyncSend(boolean b) {
        this.asyncSend = b;
    }

    public final boolean getAsyncSend() {
        return this.asyncSend;
    }

    public Vector getMessages() {
        if (this.messages == null) {
            this.messages = new Vector();
        }
        return this.messages;
    }

    public void addMessage(Message msg) {
        if (this.messages == null) {
            this.messages = new Vector();
        }
        this.messages.addElement(msg);
    }

    public void addMessages(Vector msgs) {
        if (this.messages == null) {
            this.messages = new Vector();
        }
        Enumeration e = msgs.elements();
        while (e.hasMoreElements()) {
            this.messages.addElement(e.nextElement());
        }
    }

    @Override
    protected int getClassId() {
        return 6;
    }

    public ProducerMessages(String dest) {
        super(dest);
    }

    public ProducerMessages(String dest, Message msg) {
        super(dest);
        this.messages = new Vector();
        this.messages.addElement(msg);
    }

    public ProducerMessages() {
    }

    @Override
    public void toString(StringBuffer strbuf) {
        super.toString(strbuf);
        strbuf.append(",messages=").append(this.messages);
        strbuf.append(",asyncSend=").append(this.asyncSend);
        strbuf.append(')');
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        super.writeTo(os);
        Message.writeVectorTo(this.messages, os);
        StreamUtil.writeTo(this.asyncSend, os);
    }

    @Override
    public void readFrom(InputStream is) throws IOException {
        super.readFrom(is);
        this.messages = Message.readVectorFrom(is);
        this.asyncSend = StreamUtil.readBooleanFrom(is);
    }
}

