/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.XACnxRecoverRequest;
import org.objectweb.joram.shared.stream.StreamUtil;

public final class XACnxRecoverReply
extends AbstractJmsReply {
    private static final long serialVersionUID = 1L;
    private Vector bqs;
    private Vector fis;
    private Vector gtis;

    public void setBQS(Vector bqs) {
        this.bqs = bqs;
    }

    public void setFIS(Vector fis) {
        this.fis = fis;
    }

    public void setGTIS(Vector gtis) {
        this.gtis = gtis;
    }

    @Override
    protected int getClassId() {
        return 34;
    }

    public XACnxRecoverReply(XACnxRecoverRequest req, Vector bqs, Vector fis, Vector gtis) {
        super(req.getRequestId());
        this.bqs = bqs;
        this.fis = fis;
        this.gtis = gtis;
    }

    public XACnxRecoverReply() {
    }

    public int getSize() {
        return this.bqs.size();
    }

    public byte[] getBranchQualifier(int index) {
        return (byte[])this.bqs.get(index);
    }

    public int getFormatId(int index) {
        return (Integer)this.fis.get(index);
    }

    public byte[] getGlobalTransactionId(int index) {
        return (byte[])this.gtis.get(index);
    }

    private static void writeVectorOfByteArrayTo(Vector v, OutputStream os) throws IOException {
        if (v == null) {
            StreamUtil.writeTo(-1, os);
        } else {
            int size = v.size();
            StreamUtil.writeTo(size, os);
            for (int i = 0; i < size; ++i) {
                StreamUtil.writeTo((byte[])v.elementAt(i), os);
            }
        }
    }

    private static Vector readVectorOfByteArrayFrom(InputStream is) throws IOException {
        int size = StreamUtil.readIntFrom(is);
        if (size == -1) {
            return null;
        }
        Vector<byte[]> v = new Vector<byte[]>(size);
        for (int i = 0; i < size; ++i) {
            v.addElement(StreamUtil.readByteArrayFrom(is));
        }
        return v;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        super.writeTo(os);
        XACnxRecoverReply.writeVectorOfByteArrayTo(this.bqs, os);
        if (this.fis == null) {
            StreamUtil.writeTo(-1, os);
        } else {
            int size = this.fis.size();
            StreamUtil.writeTo(size, os);
            for (int i = 0; i < size; ++i) {
                StreamUtil.writeTo((Integer)this.fis.elementAt(i), os);
            }
        }
        XACnxRecoverReply.writeVectorOfByteArrayTo(this.gtis, os);
    }

    @Override
    public void readFrom(InputStream is) throws IOException {
        super.readFrom(is);
        this.bqs = XACnxRecoverReply.readVectorOfByteArrayFrom(is);
        int size = StreamUtil.readIntFrom(is);
        if (size == -1) {
            this.fis = null;
        } else {
            this.fis = new Vector(size);
            for (int i = 0; i < size; ++i) {
                this.fis.addElement(new Integer(StreamUtil.readIntFrom(is)));
            }
        }
        this.gtis = XACnxRecoverReply.readVectorOfByteArrayFrom(is);
    }
}

