/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.joram.shared.stream.StreamUtil;
import org.objectweb.util.monolog.api.BasicLevel;

public class SimpleIdentity
extends Identity {
    private static final long serialVersionUID = 1L;
    private String user;
    private String passwd;

    @Override
    public String getUserName() {
        return this.user;
    }

    @Override
    public void setUserName(String userName) {
        this.user = userName;
    }

    @Override
    public Object getCredential() {
        return this.passwd;
    }

    @Override
    public void setIdentity(String user, String passwd) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("setIdentity(" + user + ", ****)"));
        }
        this.user = user;
        this.passwd = passwd;
    }

    @Override
    public boolean check(Identity identity) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("SimpleIdentity.check(" + identity + ')'));
        }
        if (!(identity instanceof SimpleIdentity)) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)("check : SimpleIdentity is expected for " + identity));
            }
            throw new Exception("check : SimpleIdentity is expected for " + identity);
        }
        if (!this.getUserName().equals(identity.getUserName())) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)("Invalid user [" + this.getUserName() + "] wait [" + identity.getUserName() + "]"));
            }
            throw new Exception("Invalid user [" + this.getUserName() + "] wait [" + identity.getUserName() + "]");
        }
        if (!this.getCredential().equals(identity.getCredential())) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)("Invalid credential for user [" + identity.getUserName() + "]"));
            }
            throw new Exception("Invalid credential for user [" + identity.getUserName() + "]");
        }
        return true;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(super.toString()).append('(');
        buff.append("user=").append(this.user);
        buff.append(')');
        return buff.toString();
    }

    @Override
    public void readFrom(InputStream is) throws IOException {
        this.user = StreamUtil.readStringFrom(is);
        this.passwd = StreamUtil.readStringFrom(is);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("SimpleIdentity.readFrom: user=" + this.user));
        }
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("SimpleIdentity.writeTo: user=" + this.user));
        }
        StreamUtil.writeTo(this.user, os);
        StreamUtil.writeTo(this.passwd, os);
    }
}

