/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.stream.InputStreamForker;
import com.ebmwebsourcing.easycommons.stream.ReaderInputStream;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.Transformers;
import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.Charset;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.component.framework.api.exception.DocumentException;
import org.ow2.petals.component.framework.api.exception.FaultException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SourceUtil {
    private static final String SOAPENV_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";

    private static final InputStream forkStreamSource(StreamSource streamSource) {
        InputStream isContent = streamSource.getInputStream();
        InputStreamForker streamForker = isContent != null ? new InputStreamForker(isContent) : new InputStreamForker((InputStream)new ReaderInputStream(streamSource.getReader()));
        try {
            streamSource.setInputStream(streamForker.fork());
            return streamForker.fork();
        }
        catch (IOException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public static final Document createDocument(Source source) throws PEtALSCDKException {
        return SourceUtil.createDocument(source, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Document createDocument(Source source, boolean forkSource) throws PEtALSCDKException {
        Document document;
        block14: {
            document = null;
            try {
                if (source instanceof DOMSource) {
                    Node originalNode = ((DOMSource)source).getNode();
                    if (originalNode instanceof Document) {
                        Document originalDocument = (Document)originalNode;
                        if (forkSource) {
                            document = DocumentBuilders.newDocument();
                            document.appendChild(document.importNode(originalDocument.getDocumentElement(), true));
                        } else {
                            document = originalDocument;
                        }
                    } else {
                        document = DocumentBuilders.newDocument();
                        if (forkSource) {
                            document.appendChild(document.importNode(originalNode, true));
                        } else {
                            document.appendChild(document.adoptNode(originalNode));
                        }
                    }
                }
                if (document != null) break block14;
                Source tempSource = source;
                if (forkSource && source instanceof StreamSource) {
                    tempSource = new StreamSource(SourceUtil.forkStreamSource((StreamSource)source));
                }
                document = DocumentBuilders.newDocument();
                DOMResult domResult = new DOMResult(document);
                Transformer transformer = Transformers.takeTransformer();
                try {
                    transformer.transform(tempSource, domResult);
                }
                finally {
                    Transformers.releaseTransformer((Transformer)transformer);
                }
            }
            catch (TransformerException e) {
                throw new PEtALSCDKException((Throwable)e);
            }
            catch (PoolException e) {
                throw new PEtALSCDKException((Throwable)e);
            }
        }
        return document;
    }

    public static final DOMSource createDOMSource(Document document) {
        document.normalizeDocument();
        return new DOMSource(document);
    }

    public static final Document createSoapFaultDocument(Throwable e, QName errorCode) {
        PrintWriter pw;
        StringWriter sw;
        String details;
        QName faultCode = errorCode;
        String faultString = e.getMessage();
        if (faultString == null) {
            faultString = "null message";
        }
        URI faultActor = null;
        if (e instanceof DocumentException) {
            faultCode = ((DocumentException)e).getFaultCode();
            faultActor = ((DocumentException)e).getFaultActor();
            Document document = ((DocumentException)e).getDocument();
            if (document != null) {
                try {
                    details = XMLHelper.createStringFromDOMDocument((Node)document);
                }
                catch (TransformerException e1) {
                    details = "An error occured when retrieving the exception document (" + e1.getMessage() + ").";
                }
                catch (PoolException e1) {
                    details = "An error occured when retrieving the exception document (" + e1.getMessage() + ").";
                }
            } else {
                details = "";
            }
        } else if (e instanceof FaultException) {
            faultCode = ((FaultException)e).getFaultCode();
            faultActor = ((FaultException)e).getFaultActor();
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            details = sw.toString();
        } else {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            details = sw.toString();
        }
        Document faultDocument = DocumentBuilders.newDocument();
        Element faultElement = faultDocument.createElementNS(SOAPENV_NAMESPACE, "soapenv:Fault");
        if (!SourceUtil.isDOM3(faultDocument)) {
            Attr attr = faultDocument.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:soapenv");
            attr.appendChild(faultDocument.createTextNode(SOAPENV_NAMESPACE));
            faultElement.setAttributeNode(attr);
        }
        faultDocument.appendChild(faultElement);
        Element faultCodeElement = faultDocument.createElement("faultcode");
        if (faultCode != null) {
            if (faultCode.getNamespaceURI() != null) {
                if (faultCode.getNamespaceURI().equals(SOAPENV_NAMESPACE)) {
                    faultCodeElement.appendChild(faultDocument.createTextNode("soapenv:" + faultCode.getLocalPart()));
                } else {
                    String faultCodePrefix = faultCode.getPrefix();
                    if (StringHelper.isNullOrEmpty((String)faultCodePrefix)) {
                        faultCodePrefix = "fcns";
                    }
                    Attr attr = faultDocument.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + faultCodePrefix);
                    attr.appendChild(faultDocument.createTextNode(faultCode.getNamespaceURI()));
                    faultCodeElement.setAttributeNode(attr);
                    faultCodeElement.appendChild(faultDocument.createTextNode(faultCodePrefix + ":" + faultCode.getLocalPart()));
                }
            } else {
                faultCodeElement.appendChild(faultDocument.createTextNode(faultCode.getLocalPart()));
            }
        }
        Element faultStringElement = faultDocument.createElement("faultstring");
        faultStringElement.appendChild(faultDocument.createCDATASection(faultString));
        Element faultDetailElement = faultDocument.createElement("detail");
        if (e instanceof DocumentException) {
            faultDetailElement.appendChild(faultDocument.createCDATASection(details));
        } else {
            Element stackTrace = faultDocument.createElement("stackTrace");
            faultDetailElement.appendChild(stackTrace);
            stackTrace.appendChild(faultDocument.createCDATASection(details));
        }
        Element faultActorElement = faultDocument.createElement("faultactor");
        if (faultActor != null) {
            faultActorElement.appendChild(faultDocument.createTextNode(faultActor.toString()));
        }
        faultElement.appendChild(faultCodeElement);
        faultElement.appendChild(faultStringElement);
        faultElement.appendChild(faultActorElement);
        faultElement.appendChild(faultDetailElement);
        return faultDocument;
    }

    public static final Source createSource(String message) throws PEtALSCDKException {
        String charsetEncoding = Charset.defaultCharset().displayName();
        return SourceUtil.createSource(message, charsetEncoding);
    }

    public static final Source createSource(String message, String charFormat) throws PEtALSCDKException {
        StreamSource source = new StreamSource();
        try {
            byte[] msgByte = message.getBytes(charFormat);
            ByteArrayInputStream in = new ByteArrayInputStream(msgByte);
            source.setInputStream(in);
        }
        catch (IOException e) {
            throw new PEtALSCDKException((Throwable)e);
        }
        return source;
    }

    public static final StreamSource createStreamSource(Document document) throws PEtALSCDKException {
        ByteArrayOutputStream bufferOut = new ByteArrayOutputStream();
        StreamResult sResult = new StreamResult(bufferOut);
        Transformer transformer = null;
        try {
            transformer = Transformers.takeTransformer();
            transformer.transform(new DOMSource(document), sResult);
        }
        catch (TransformerException e) {
            throw new PEtALSCDKException("Error while transform DOM document to StreamSource", (Throwable)e);
        }
        catch (PoolException e) {
            throw new PEtALSCDKException("Error while transform DOM document to StreamSource", (Throwable)e);
        }
        finally {
            if (transformer != null) {
                Transformers.releaseTransformer((Transformer)transformer);
            }
        }
        ByteArrayInputStream bufferIn = new ByteArrayInputStream(bufferOut.toByteArray());
        return new StreamSource(bufferIn);
    }

    public static final String createString(Source source) throws PEtALSCDKException {
        return SourceUtil.createString(source, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String createString(Source source, boolean forkSource) throws PEtALSCDKException {
        Source tempSource = source;
        if (forkSource && source instanceof StreamSource) {
            tempSource = new StreamSource(SourceUtil.forkStreamSource((StreamSource)source));
        }
        try {
            StringWriter buffer = new StringWriter();
            StreamResult sresult = new StreamResult(buffer);
            Transformer transformer = Transformers.takeTransformer();
            try {
                transformer.transform(tempSource, sresult);
            }
            finally {
                Transformers.releaseTransformer((Transformer)transformer);
            }
            return buffer.toString();
        }
        catch (TransformerException e) {
            throw new PEtALSCDKException((Throwable)e);
        }
        catch (PoolException e) {
            throw new PEtALSCDKException((Throwable)e);
        }
    }

    public static final boolean isDOM3(Document document) {
        boolean result = true;
        try {
            document.getClass().getMethod("getBaseURI", null);
        }
        catch (NoSuchMethodException e) {
            result = false;
        }
        return result;
    }
}

