/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.nhttp;

import org.apache.axis2.transport.nhttp.LoggingIOSession;
import org.apache.axis2.transport.nhttp.LoggingNHttpServerConnection;
import org.apache.axis2.transport.nhttp.LoggingNHttpServiceHandler;
import org.apache.http.HttpRequestFactory;
import org.apache.http.impl.DefaultHttpRequestFactory;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.HttpParams;

public class PlainServerIOEventDispatch
implements IOEventDispatch {
    private static final String NHTTP_CONN = "AXIS2.NHTTP_CONN";
    private final NHttpServiceHandler handler;
    private final HttpParams params;

    public PlainServerIOEventDispatch(NHttpServiceHandler handler, HttpParams params) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP service handler may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.handler = new LoggingNHttpServiceHandler(handler);
        this.params = params;
    }

    public void connected(IOSession session) {
        LoggingNHttpServerConnection conn = new LoggingNHttpServerConnection(new LoggingIOSession(session), (HttpRequestFactory)new DefaultHttpRequestFactory(), (ByteBufferAllocator)new HeapByteBufferAllocator(), this.params);
        session.setAttribute(NHTTP_CONN, (Object)conn);
        this.handler.connected((NHttpServerConnection)conn);
    }

    public void disconnected(IOSession session) {
        DefaultNHttpServerConnection conn = (DefaultNHttpServerConnection)session.getAttribute(NHTTP_CONN);
        this.handler.closed((NHttpServerConnection)conn);
    }

    public void inputReady(IOSession session) {
        DefaultNHttpServerConnection conn = (DefaultNHttpServerConnection)session.getAttribute(NHTTP_CONN);
        conn.consumeInput(this.handler);
    }

    public void outputReady(IOSession session) {
        DefaultNHttpServerConnection conn = (DefaultNHttpServerConnection)session.getAttribute(NHTTP_CONN);
        conn.produceOutput(this.handler);
    }

    public void timeout(IOSession session) {
        DefaultNHttpServerConnection conn = (DefaultNHttpServerConnection)session.getAttribute(NHTTP_CONN);
        this.handler.timeout((NHttpServerConnection)conn);
    }
}

