/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.io;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class IOHelper {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    private IOHelper() {
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            throw new UncheckedException(String.format("Cannot close object of class '%s'.", closeable.getClass().getSimpleName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getLine(File file, int lineNum) throws IOException {
        assert (file != null);
        assert (lineNum > 0);
        String strLine = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            strLine = br.readLine();
            for (int counter = 1; strLine != null && counter < lineNum; ++counter) {
                strLine = br.readLine();
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return strLine;
    }

    public static final String readFileAsString(File file) throws IOException {
        return new String(IOHelper.readFileAsBytes(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileAsBytes(File file) throws IOException {
        byte[] byArray;
        assert (file != null);
        if (file.canRead() && file.length() == 0L) {
            return EMPTY_BYTE_ARRAY;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] readBytes = new byte[(int)file.length()];
            int nbRead = fis.read(readBytes);
            assert (nbRead == readBytes.length);
            byArray = readBytes;
        }
        catch (Throwable throwable) {
            IOHelper.close(fis);
            throw throwable;
        }
        IOHelper.close(fis);
        return byArray;
    }
}

