/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import com.ebmwebsourcing.easycommons.pooling.GenericResourcePool;
import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.pooling.PoolPolicy;
import com.ebmwebsourcing.easycommons.pooling.ResourceHandler;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;

public class TransformerResourcePool {
    private final GenericResourcePool<Transformer> transformerResourcePool;

    public TransformerResourcePool(int minPoolSize, int maxPoolSize, PoolPolicy poolPolicy) {
        TransformerResourceHandler transformerResourceHandler = new TransformerResourceHandler();
        this.transformerResourcePool = new GenericResourcePool<Transformer>(transformerResourceHandler, minPoolSize, maxPoolSize, poolPolicy);
    }

    public Transformer take() {
        return this.transformerResourcePool.take();
    }

    public final void release(Transformer transformer) {
        this.transformerResourcePool.release(transformer);
    }

    private static class TransformerResourceHandler
    implements ResourceHandler<Transformer> {
        final TransformerFactory transformerFactory = TransformerFactory.newInstance();

        @Override
        public Transformer create() {
            try {
                return this.transformerFactory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new PoolException(e);
            }
        }

        @Override
        public void onRelease(Transformer transformer) {
            transformer.reset();
        }

        @Override
        public void onTake(Transformer transformer) {
        }
    }
}

