/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.jsr181.test;

import java.util.Iterator;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import org.ow2.petals.se.jsr181.test.Directory;
import org.ow2.petals.se.jsr181.test.NotFoundException;
import org.ow2.petals.se.jsr181.test.Person;
import org.ow2.petals.se.jsr181.test.PersonList;

@WebService(serviceName="DirectoryService", targetNamespace="http://petals.ow2.org/", portName="DirectoryServicePort")
public class DirectoryService {
    @WebMethod(operationName="addPerson")
    @WebResult(name="status")
    public boolean addPerson(@WebParam(name="person") Person person) {
        return Directory.getInstance().add(person);
    }

    @WebMethod(operationName="addPersons")
    @WebResult(name="status")
    public boolean addPersons(@WebParam(name="persons") PersonList persons) {
        return Directory.getInstance().addAll(persons.getPersonList());
    }

    @WebMethod(operationName="getAllPersons")
    @WebResult(name="persons")
    public PersonList getAllPersons() {
        PersonList persons = new PersonList();
        persons.getPersonList().addAll(Directory.getInstance());
        return persons;
    }

    @WebMethod(operationName="getPersonsBySurName")
    @WebResult(name="persons")
    public PersonList getPersonsBySurName(@WebParam(name="surname") String surname) {
        PersonList selectedPersons = new PersonList();
        for (Person person : Directory.getInstance()) {
            if (!person.getSurname().equals(surname)) continue;
            selectedPersons.getPersonList().add(person);
        }
        return selectedPersons;
    }

    @WebMethod(operationName="getPersonsByBirthYear")
    @WebResult(name="persons")
    public PersonList getPersonsByBirthYear(@WebParam(name="birthYear") int birthYear) {
        PersonList selectedPersons = new PersonList();
        for (Person person : Directory.getInstance()) {
            if (person.getBirthday().get(1) != birthYear) continue;
            selectedPersons.getPersonList().add(person);
        }
        return selectedPersons;
    }

    @WebMethod(operationName="getSex")
    @WebResult(name="sex")
    public Person.Sex getSex(@WebParam(name="firstName") String firstName) throws NotFoundException {
        Person.Sex sex = null;
        Iterator<Person> personsIterator = Directory.getInstance().iterator();
        boolean isFound = false;
        while (personsIterator.hasNext() && !isFound) {
            Person person = personsIterator.next();
            if (!person.getFirstName().equals(firstName)) continue;
            sex = person.getSex();
        }
        if (sex == null) {
            throw new NotFoundException(String.format("Nobody was found with the firstName %s", firstName));
        }
        return sex;
    }
}

