/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.easierbsm.connector;

import easyesb.petalslink.com.service.wsdmadmin._1_0.AdminExceptionMsg;
import easyesb.petalslink.com.service.wsdmadmin._1_0.WSDMAdminItf;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.api.DSBException;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.cxf.CXFHelper;
import org.petalslink.dsb.monitoring.api.MonitoringAdminClient;

public class EasierBSMAdminClient
implements MonitoringAdminClient {
    private static final String ENDPOINT_SUFFIX = "_WSDMMonitoring";
    private String address;
    private WSDMAdminItf wsdmAdmin;
    private static Log logger = LogFactory.getLog(EasierBSMAdminClient.class);

    public EasierBSMAdminClient(String address) {
        this.address = address;
    }

    public void createMonitoringEndpoint(ServiceEndpoint serviceEndpoint) throws DSBException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Creating monitoring endpoint for service " + serviceEndpoint));
        }
        if (serviceEndpoint == null) {
            String message = "Can not create monitoring endpoint from null endpoint...";
            throw new DSBException("Can not create monitoring endpoint from null endpoint...");
        }
        WSDMAdminItf wsdmAdminItf = this.getAdminClient();
        String wsdmProviderEndpointName = String.valueOf(serviceEndpoint.getEndpointName()) + ENDPOINT_SUFFIX;
        String result = null;
        try {
            result = wsdmAdminItf.createMonitoringEndpoint(serviceEndpoint.getServiceName(), wsdmProviderEndpointName, true);
        }
        catch (AdminExceptionMsg e) {
            String message = "Error while sending request to monitoring layer";
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"Error while sending request to monitoring layer", (Throwable)e);
            }
            throw new DSBException("Error while sending request to monitoring layer", (Throwable)e);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Monitoring bus returned " + result));
        }
    }

    private synchronized WSDMAdminItf getAdminClient() {
        if (this.wsdmAdmin == null) {
            this.wsdmAdmin = (WSDMAdminItf)CXFHelper.getClientFromFinalURL((String)this.address, WSDMAdminItf.class);
        }
        return this.wsdmAdmin;
    }

    public void deleteMonitoringEndpoint(ServiceEndpoint serviceEndpoint) throws DSBException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Deleting monitoring endpoint for service " + serviceEndpoint));
        }
        throw new DSBException("deleteMonitoringEndpoint is not implemented");
    }
}

