/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.easierbsm.connector;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.easierbsm.connector.EasierBSMAdminClient;
import org.petalslink.dsb.easierbsm.connector.EasierBSMClient;
import org.petalslink.dsb.monitoring.api.MonitoringAdminClient;
import org.petalslink.dsb.monitoring.api.MonitoringClient;
import org.petalslink.dsb.monitoring.api.MonitoringClientFactory;

public class EasierBSMClientFactory
implements MonitoringClientFactory {
    private static Log logger = LogFactory.getLog(EasierBSMClientFactory.class);
    private Map<String, MonitoringClient> monitoringClients;
    private Map<String, MonitoringAdminClient> monitoringAdminClients;

    public EasierBSMClientFactory() {
        System.out.println("instanciate");
        this.monitoringAdminClients = new ConcurrentHashMap<String, MonitoringAdminClient>();
        this.monitoringClients = new ConcurrentHashMap<String, MonitoringClient>();
    }

    public MonitoringClient getMonitoringClient(String address) {
        logger.info((Object)("Getting new monitoring client for " + address));
        if (this.monitoringClients.get(address) == null) {
            this.monitoringClients.put(address, new EasierBSMClient(address));
        }
        return this.monitoringClients.get(address);
    }

    public MonitoringAdminClient getMonitoringAdminClient(String address) {
        logger.info((Object)("Getting new admin monitoring client for " + address));
        if (this.monitoringAdminClients.get(address) == null) {
            this.monitoringAdminClients.put(address, new EasierBSMAdminClient(address));
        }
        return this.monitoringAdminClients.get(address);
    }
}

