/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.easierbsm.connector;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.petalslink.dsb.easierbsm.connector.EasierBSMAdminClient;
import org.petalslink.dsb.easierbsm.connector.EasierBSMClient;
import org.petalslink.dsb.monitoring.api.MonitoringAdminClient;
import org.petalslink.dsb.monitoring.api.MonitoringClient;
import org.petalslink.dsb.monitoring.api.MonitoringClientFactory;

public class EasierBSMClientFactory
implements MonitoringClientFactory {
    public static final String BASE_URL = "easierbsm.base";
    public static final String ADMIN_URL = "easierbsm.admin";
    public static final String WSDM_SUFFIX = "_WSDMMonitoring";
    public static final String FINAL_ENDPOINT_SUFFIX = "_WSDMMonitoringClientProxyEndpoint";
    private static final String RAW_REPORT_SERVICE_ENDPOINT = "rawReportEndpointClientProxyEndpoint";
    private static final String DISPATCHER_ENDPOINT = "DispatcherProviderEndpointClientProxyEndpoint";
    private static Logger logger = Logger.getLogger(EasierBSMClientFactory.class.getName());
    private Map<String, MonitoringClient> monitoringClients;
    private Map<String, MonitoringAdminClient> monitoringAdminClients;
    private Properties props;

    public EasierBSMClientFactory(Properties props) {
        this.props = props;
        this.monitoringAdminClients = new ConcurrentHashMap<String, MonitoringAdminClient>();
        this.monitoringClients = new ConcurrentHashMap<String, MonitoringClient>();
    }

    public MonitoringClient getMonitoringClient(String endpointName) {
        String address;
        logger.info("Getting new monitoring client for endpoint " + endpointName);
        String baseURL = this.props.getProperty(BASE_URL);
        if (baseURL == null) {
            return null;
        }
        baseURL = baseURL.trim();
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        if (this.monitoringClients.get(address = baseURL + DISPATCHER_ENDPOINT) == null) {
            this.monitoringClients.put(address, new EasierBSMClient(address));
        }
        return this.monitoringClients.get(address);
    }

    public MonitoringAdminClient getMonitoringAdminClient() {
        logger.info("Getting new admin monitoring client");
        String baseURL = this.props.getProperty(ADMIN_URL);
        if (baseURL == null) {
            return null;
        }
        baseURL = baseURL.trim();
        if (this.monitoringAdminClients.get(baseURL) == null) {
            this.monitoringAdminClients.put(baseURL, new EasierBSMAdminClient(baseURL));
        }
        return this.monitoringAdminClients.get(baseURL);
    }

    public MonitoringClient getRawMonitoringClient() {
        String address;
        logger.info("Getting new RAW monitoring client");
        String baseURL = this.props.getProperty(BASE_URL);
        if (baseURL == null) {
            return null;
        }
        baseURL = baseURL.trim();
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        if (this.monitoringClients.get(address = baseURL + RAW_REPORT_SERVICE_ENDPOINT) == null) {
            this.monitoringClients.put(address, new EasierBSMClient(address));
        }
        return this.monitoringClients.get(address);
    }
}

