/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.core.client;

import java.util.Set;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.api.EndpointQuery;
import org.petalslink.dsb.api.MessageExchange;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.federation.api.FederationException;
import org.petalslink.dsb.federation.api.client.FederationCallback;
import org.petalslink.dsb.federation.api.client.FederationService;
import org.petalslink.dsb.federation.core.client.FederationClientImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService
public class FederationClientServiceWrapperImpl
implements org.petalslink.dsb.federation.api.FederationService {
    private static Log logger = LogFactory.getLog(FederationClientServiceWrapperImpl.class);
    private FederationService clientService;
    private FederationCallback callback;
    private org.petalslink.dsb.federation.api.FederationService federationServiceClient;
    private final FederationClientImpl client;

    public FederationClientServiceWrapperImpl(FederationClientImpl client) {
        this.client = client;
    }

    public void setClientService(FederationService clientService) {
        this.clientService = clientService;
    }

    public void setCallback(FederationCallback callback) {
        this.callback = callback;
    }

    public void setFederationServiceClient(org.petalslink.dsb.federation.api.FederationService federationServiceClient) {
        this.federationServiceClient = federationServiceClient;
    }

    public void invoke(MessageExchange message, String clientId, String id) throws FederationException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Got an incoming invoke query from client " + clientId + " and id " + id));
        }
        this.clientService.invoke(message);
    }

    public void lookup(EndpointQuery query, String clientId, String id) throws FederationException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Got an incoming lookup query from client " + clientId + " and id " + id));
        }
        Set result = this.clientService.lookup(query);
        this.federationServiceClient.lookupReply(result, this.client.getName(), id);
    }

    public void lookupReply(Set<ServiceEndpoint> endpoints, String clientId, String id) throws FederationException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("In client " + this.client.getName() + " Got an incoming lookup reply from client " + clientId + ", let's unlock all..."));
        }
        this.callback.onLookupResponse(endpoints, id);
    }
}

