/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.core.commons.impl.cxf.client;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.petalslink.dsb.federation.api.FederationException;
import org.petalslink.dsb.federation.api.FederationManagementService;

public class CXFFederationManagementClientImpl
implements FederationManagementService {
    private final FederationManagementService client;
    private static Log logger = LogFactory.getLog(CXFFederationManagementClientImpl.class);

    public CXFFederationManagementClientImpl(String address) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Creating federation management service client for service at " + address));
        }
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(FederationManagementService.class);
        factory.setAddress(address);
        this.client = (FederationManagementService)factory.create();
    }

    public void join(String clientId, String callbackURL) throws FederationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Call to join federation");
        }
        this.client.join(clientId, callbackURL);
    }

    public void leave(String clientId) throws FederationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Call to leave federation");
        }
        this.client.leave(clientId);
    }
}

