/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.core.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.federation.api.FederationException;
import org.petalslink.dsb.federation.api.FederationManagementService;
import org.petalslink.dsb.federation.core.api.FederationServer;

public class FederationManagementServiceImpl
implements FederationManagementService {
    private final FederationServer federationServer;
    private static Log logger = LogFactory.getLog(FederationManagementServiceImpl.class);

    public FederationManagementServiceImpl(FederationServer federationServer) {
        this.federationServer = federationServer;
    }

    public void join(String clientId, String callbackURL) throws FederationException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Federation client '" + clientId + "' joining federation with callback '" + callbackURL + "'"));
        }
        this.federationServer.addClient(clientId, callbackURL);
    }

    public void leave(String clientId) throws FederationException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Federation client '" + clientId + "' leaving federation"));
        }
        this.federationServer.removeClient(clientId);
    }
}

