/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.core.server;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.api.EndpointQuery;
import org.petalslink.dsb.api.MessageExchange;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.federation.api.FederationException;
import org.petalslink.dsb.federation.api.FederationService;
import org.petalslink.dsb.federation.core.api.FederationServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FederationServiceImpl
implements FederationService {
    private final FederationServer federationServer;
    private static Log logger = LogFactory.getLog(FederationServiceImpl.class);

    public FederationServiceImpl(FederationServer federationServer) {
        this.federationServer = federationServer;
    }

    public void invoke(MessageExchange message, String clientId, String id) throws FederationException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Receive 'invoke' from clientID = '" + clientId + "'"));
        }
        this.federationServer.invoke(message, clientId, id);
    }

    public void lookup(EndpointQuery query, String clientId, String id) throws FederationException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Receive 'lookup' from clientID = '" + clientId + "'"));
        }
        this.federationServer.lookup(query, clientId, id);
    }

    public void lookupReply(Set<ServiceEndpoint> endpoints, String clientId, String id) throws FederationException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Receive 'lookupReply' from clientID = '" + clientId + "'"));
        }
        this.federationServer.lookupReply(endpoints, clientId, id);
    }
}

