/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.core.server;

import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.federation.core.api.FederationClient;
import org.petalslink.dsb.federation.core.api.FederationServer;
import org.petalslink.dsb.federation.core.api.PeerChecker;
import org.petalslink.dsb.federation.core.api.Service;

public class RemoteCheckerServiceImpl
implements Service {
    private final FederationServer server;
    private final ScheduledExecutorService scheduledExecutorService;
    private final PeerChecker peerChecker;
    private static Log logger = LogFactory.getLog(RemoteCheckerServiceImpl.class);

    public RemoteCheckerServiceImpl(FederationServer server, PeerChecker peerChecker) {
        this.server = server;
        this.peerChecker = peerChecker;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    }

    public String getName() {
        return RemoteCheckerServiceImpl.class.getName();
    }

    public int getPriority() {
        return 0;
    }

    public Service.TYPE getType() {
        return Service.TYPE.INTERNAL;
    }

    public void start() {
        Runnable command = new Runnable(){

            public void run() {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Running task in " + RemoteCheckerServiceImpl.this.getName()));
                }
                Set<FederationClient> set = RemoteCheckerServiceImpl.this.server.getClients();
                for (FederationClient federationClient : set) {
                    RemoteCheckerServiceImpl.this.checkPeer(federationClient);
                }
            }
        };
        this.scheduledExecutorService.scheduleAtFixedRate(command, 10L, 10L, TimeUnit.SECONDS);
    }

    protected void checkPeer(FederationClient federationClient) {
        boolean isAvailable = this.peerChecker.check(federationClient.getCallbackURL());
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Peer " + federationClient.getName() + " is available " + isAvailable));
        }
        if (!isAvailable) {
            this.server.getPeerManager().onUnreachable(federationClient.getName());
        }
    }

    public void stop() {
        this.scheduledExecutorService.shutdownNow();
    }
}

