/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.core.client;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.api.EndpointQuery;
import org.petalslink.dsb.api.MessageExchange;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.federation.api.FederationException;
import org.petalslink.dsb.federation.api.client.FederationService;
import org.petalslink.dsb.federation.core.api.ClientManager;
import org.petalslink.dsb.federation.core.client.FederationClientServiceWrapperImpl;
import org.petalslink.dsb.federation.core.client.FederationClientWithCallback;
import org.petalslink.dsb.federation.core.client.ServiceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FederationClientImpl
implements FederationClientWithCallback {
    private String name;
    private String callbackURL;
    AtomicLong counter = new AtomicLong(0L);
    private static Log logger = LogFactory.getLog(FederationClientImpl.class);
    private FederationService serviceImplementation;
    private ServiceManager serviceManager;
    private ClientManager clientManager;
    private final Map<String, CountDownLatch> latches;
    private final Map<String, Set<ServiceEndpoint>> endpoints;
    private final String serverURL;
    private final String serverURLMgmt;

    public FederationClientImpl(String name, String callbackURL, String serverURL, String serverURLMgmt) {
        this.name = name;
        this.callbackURL = callbackURL;
        this.serverURL = serverURL;
        this.serverURLMgmt = serverURLMgmt;
        this.latches = new ConcurrentHashMap<String, CountDownLatch>(100);
        this.endpoints = new ConcurrentHashMap<String, Set<ServiceEndpoint>>(100);
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceImplementation(FederationService federationService) {
        this.serviceImplementation = federationService;
    }

    @Override
    public void stop() {
        if (this.getServiceManager() != null) {
            this.getServiceManager().stop();
        }
    }

    @Override
    public void start() {
        FederationClientServiceWrapperImpl service = this.createServiceWrapper();
        if (this.getServiceManager() != null) {
            this.getServiceManager().expose(this.callbackURL, service);
        }
    }

    private FederationClientServiceWrapperImpl createServiceWrapper() {
        FederationClientServiceWrapperImpl service = new FederationClientServiceWrapperImpl(this);
        service.setCallback(this);
        service.setClientService(this.serviceImplementation);
        service.setFederationServiceClient(this.getClientManager().getClient(this.serverURL));
        return service;
    }

    public void invoke(MessageExchange message) throws FederationException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Client invoke");
        }
        this.getClientManager().getClient(this.serverURL).invoke(message, this.name, this.getNewUUID());
    }

    public void join() throws FederationException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Client join federation");
        }
        this.getClientManager().getManagementClient(this.serverURLMgmt).join(this.name, this.callbackURL);
    }

    public void leave() throws FederationException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Client leave federation");
        }
        this.getClientManager().getManagementClient(this.serverURLMgmt).leave(this.name);
    }

    public Set<ServiceEndpoint> lookup(EndpointQuery query) throws FederationException {
        Set<ServiceEndpoint> endpoints;
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Client lookup");
        }
        HashSet<ServiceEndpoint> result = new HashSet<ServiceEndpoint>();
        String id = this.getNewUUID();
        CountDownLatch latch = new CountDownLatch(1);
        this.latches.put(id, latch);
        this.getClientManager().getClient(this.serverURL).lookup(query, this.name, id);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Waiting for response, id is " + id));
            }
            latch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.warn((Object)"Can not get a response within 30 seconds...");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got a response for id " + id));
        }
        if ((endpoints = this.endpoints.remove(id)) != null) {
            result.addAll(endpoints);
        }
        return result;
    }

    public void onLookupResponse(Set<ServiceEndpoint> endpoints, String id) throws FederationException {
        CountDownLatch latch;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Client onLookupResponse for id " + id));
        }
        if ((latch = this.latches.remove(id)) != null) {
            this.endpoints.put(id, endpoints);
            latch.countDown();
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)"Can not find something to unlock...");
        }
    }

    private String getNewUUID() {
        return "fed-" + this.name + "-" + this.counter.getAndIncrement() + "-" + UUID.randomUUID().toString();
    }

    public ClientManager getClientManager() {
        return this.clientManager;
    }

    public void setClientManager(ClientManager clientManager) {
        this.clientManager = clientManager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCallbackURL() {
        return this.callbackURL;
    }

    public void setCallbackURL(String callbackURL) {
        this.callbackURL = callbackURL;
    }
}

