/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.core.commons;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.federation.api.FederationManagementService;
import org.petalslink.dsb.federation.api.FederationService;
import org.petalslink.dsb.federation.core.api.ClientManager;
import org.petalslink.dsb.federation.core.commons.ClientFactory;

public class ClientManagerImpl
implements ClientManager {
    Map<String, FederationService> clients = new ConcurrentHashMap<String, FederationService>(5);
    Map<String, FederationManagementService> managementClients = new ConcurrentHashMap<String, FederationManagementService>(1);
    private ClientFactory clientFactory;
    private static Log logger = LogFactory.getLog(ClientManagerImpl.class);

    public synchronized FederationService getClient(String callbackURL) {
        FederationService result;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Get client for federation client " + callbackURL));
        }
        if ((result = this.clients.get(callbackURL)) == null) {
            result = this.getClientFactory().createClient(callbackURL);
            this.clients.put(callbackURL, result);
        }
        return result;
    }

    public void removeClient(String callbackURL) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing client for federation client " + callbackURL));
        }
        if (callbackURL == null) {
            return;
        }
        this.clients.remove(callbackURL);
    }

    public ClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public void setClientFactory(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public FederationManagementService getManagementClient(String callbackURL) {
        FederationManagementService result;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Get management client for federation client " + callbackURL));
        }
        if ((result = this.managementClients.get(callbackURL)) == null) {
            result = this.getClientFactory().createManagementClient(callbackURL);
            this.managementClients.put(callbackURL, result);
        }
        return result;
    }

    public void removeManagementClient(String callbackURL) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing management client for federation client " + callbackURL));
        }
        if (callbackURL == null) {
            return;
        }
        this.managementClients.remove(callbackURL);
    }
}

