/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.core.commons.impl.cxf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.petalslink.dsb.federation.api.FederationManagementService;
import org.petalslink.dsb.federation.api.FederationService;
import org.petalslink.dsb.federation.core.api.FederationServer;
import org.petalslink.dsb.federation.core.api.Service;
import org.petalslink.dsb.federation.core.server.FederationManagementServiceImpl;
import org.petalslink.dsb.federation.core.server.FederationServiceImpl;

public class CXFServiceInboundImpl
implements Service {
    private static Log logger = LogFactory.getLog(CXFServiceInboundImpl.class);
    private final FederationServer federationServer;
    private final FederationManagementService managementService;
    private Server managementServiceServer;
    private final FederationService federationService;
    private Server federationServiceServer;

    public CXFServiceInboundImpl(FederationServer federationServer) {
        this.federationServer = federationServer;
        this.managementService = new FederationManagementServiceImpl(federationServer);
        this.federationService = new FederationServiceImpl(federationServer);
    }

    public void start() {
        JaxWsServerFactoryBean svrFactory = new JaxWsServerFactoryBean();
        String url = this.federationServer.getCallbackURL() + "/" + "FederationManagementService";
        svrFactory.setAddress(this.federationServer.getCallbackURL());
        svrFactory.setServiceBean((Object)this.managementService);
        this.managementServiceServer = svrFactory.create();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("FederationManagementService service is started and available at " + url));
        }
        svrFactory = new JaxWsServerFactoryBean();
        url = this.federationServer.getCallbackURL() + "/" + "FederationService";
        svrFactory.setAddress(url);
        svrFactory.setServiceBean((Object)this.federationService);
        this.federationServiceServer = svrFactory.create();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("FederationService service is started and available at " + url));
        }
    }

    public void stop() {
        if (this.federationServiceServer != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Stopping FederationService service...");
            }
            this.federationServiceServer.stop();
        }
        if (this.managementServiceServer != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Stopping FederationManagementService service...");
            }
            this.managementServiceServer.stop();
        }
    }

    public String getName() {
        return "CXFServiceInbound";
    }

    public Service.TYPE getType() {
        return Service.TYPE.INBOUND;
    }

    public int getPriority() {
        return 0;
    }
}

