/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.core.commons.impl.cxf.client;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.petalslink.dsb.api.EndpointQuery;
import org.petalslink.dsb.api.MessageExchange;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.federation.api.FederationException;
import org.petalslink.dsb.federation.api.FederationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFFederationClientImpl
implements FederationService {
    private final FederationService client;
    private static Log logger = LogFactory.getLog(CXFFederationClientImpl.class);

    public CXFFederationClientImpl(String address) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Creating service client for service at " + address));
        }
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(FederationService.class);
        factory.setAddress(address);
        this.client = (FederationService)factory.create();
    }

    public void invoke(MessageExchange message, String clientId, String id) throws FederationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Invoking operation 'invoke'");
        }
        this.client.invoke(message, clientId, id);
    }

    public void lookup(EndpointQuery query, String clientId, String id) throws FederationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Invoking operation 'lookup'");
        }
        this.client.lookup(query, clientId, id);
    }

    public void lookupReply(Set<ServiceEndpoint> endpoints, String clientId, String id) throws FederationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Invoking operation 'lookupreply'");
        }
        this.client.lookupReply(endpoints, clientId, id);
    }
}

