/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.core.server;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.api.EndpointQuery;
import org.petalslink.dsb.api.MessageExchange;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.federation.api.FederationException;
import org.petalslink.dsb.federation.core.api.FederationClient;
import org.petalslink.dsb.federation.core.api.FederationServer;
import org.petalslink.dsb.federation.core.api.PropagationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropagationStrategy
implements PropagationStrategy {
    private final FederationServer federationServer;
    private final Map<String, String> idClientMap;
    private final Map<String, String> initialClientMap;
    private final Map<String, Set<ServiceEndpoint>> endpoints;
    private final Map<String, AtomicLong> latches;
    private static Log logger = LogFactory.getLog(DefaultPropagationStrategy.class);
    private final ExecutorService executorService;

    public DefaultPropagationStrategy(FederationServer federationServer) {
        this.federationServer = federationServer;
        this.idClientMap = new ConcurrentHashMap<String, String>(100);
        this.endpoints = new ConcurrentHashMap<String, Set<ServiceEndpoint>>(100);
        this.latches = new ConcurrentHashMap<String, AtomicLong>(100);
        this.initialClientMap = new ConcurrentHashMap<String, String>(100);
        this.executorService = Executors.newFixedThreadPool(10);
    }

    @Override
    public String getName() {
        return DefaultPropagationStrategy.class.getCanonicalName();
    }

    public void invoke(MessageExchange message, String clientId, String id) throws FederationException {
        if (this.initialClientMap.get(message.getId()) != null && message.getStatus().equals("Done")) {
            String initialClient = this.initialClientMap.remove(message.getId());
            if (logger.isInfoEnabled()) {
                logger.info((Object)("This is a response by " + clientId + " for initial client " + initialClient));
            }
            if (initialClient != null) {
                this.invoke2(message, initialClient, id);
            } else {
                logger.warn((Object)"Can not find a valid initial client ID");
            }
        } else {
            this.idClientMap.put(id, clientId);
            this.initialClientMap.put(message.getId(), clientId);
            String clientIdToInvoke = this.getClientToInvoke(message, clientId);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Found the client '" + clientIdToInvoke + "' to forward message to"));
            }
            if (clientIdToInvoke == null) {
                throw new FederationException("Can not define the client to invoke from the initial message");
            }
            this.invoke2(message, clientIdToInvoke, id);
        }
    }

    private void invoke2(MessageExchange message, String clientId, String id) throws FederationException {
        FederationClient client;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Got an invoke call for client = '" + clientId + "'"));
        }
        if ((client = this.federationServer.getClient(clientId)) == null) {
            String msg = "Can not find a valid client from clientID='" + clientId + "'";
            logger.warn((Object)msg);
            throw new FederationException(msg);
        }
        try {
            this.federationServer.getClientManager().getClient(client.getCallbackURL()).invoke(message, this.federationServer.getName(), id);
        }
        catch (FederationException e) {
            e.printStackTrace();
        }
    }

    public void lookup(EndpointQuery query, String clientId, String id) throws FederationException {
        Set<FederationClient> clients;
        AtomicLong counter;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got lookup call from client '" + clientId + "'"));
        }
        if ((counter = new AtomicLong((clients = this.federationServer.getClients()).size() - 1)).get() <= 0L) {
            this.submitEmptyReply(clientId, id);
        } else {
            this.idClientMap.put(id, clientId);
            this.latches.put(id, counter);
            this.endpoints.put(id, new HashSet());
            for (FederationClient federationClient : clients) {
                if (!clientId.equals(federationClient.getName())) {
                    this.submitLookup(query, id, counter, federationClient);
                    continue;
                }
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)"Do not call the client which did the request");
            }
        }
    }

    private void submitLookup(final EndpointQuery query, final String id, final AtomicLong counter, final FederationClient federationClient) {
        Thread t = new Thread(){

            public void run() {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Client " + federationClient.getName() + " with callback " + federationClient.getCallbackURL()));
                }
                try {
                    DefaultPropagationStrategy.this.federationServer.getClientManager().getClient(federationClient.getCallbackURL()).lookup(query, DefaultPropagationStrategy.this.federationServer.getName(), id);
                }
                catch (FederationException e) {
                    counter.decrementAndGet();
                }
            }
        };
        this.executorService.submit(t);
    }

    private void submitEmptyReply(final String clientId, final String id) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Submit empty reply");
        }
        Thread t = new Thread(){

            public void run() {
                try {
                    DefaultPropagationStrategy.this.lookupReply2(new HashSet(), clientId, id);
                }
                catch (FederationException e) {
                    e.printStackTrace();
                }
            }
        };
        this.executorService.submit(t);
    }

    public void lookupReply(Set<ServiceEndpoint> endpoints, String clientId, String id) throws FederationException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Got a lookupReply call from client = '" + clientId + "'"));
        }
        if (endpoints != null) {
            for (ServiceEndpoint serviceEndpoint : endpoints) {
                serviceEndpoint.setSubdomainLocation(clientId + "/" + serviceEndpoint.getSubdomainLocation());
            }
            Set<ServiceEndpoint> endpointsBuffer = this.endpoints.get(id);
            if (endpointsBuffer != null) {
                endpointsBuffer.addAll(endpoints);
            }
        }
        AtomicLong counter = this.latches.get(id);
        long remain = counter.decrementAndGet();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Waiting for " + remain + " more response"));
        }
        if (remain <= 0L) {
            this.latches.remove(id);
            if (this.idClientMap.get(id) != null) {
                String initialClient = this.idClientMap.remove(id);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("This is a response by " + clientId + " for initial client " + initialClient));
                }
                this.lookupReply2(this.endpoints.remove(id), initialClient, id);
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)"Failure, can not find a client...");
            }
        }
    }

    private void lookupReply2(Set<ServiceEndpoint> endpoints, String initialClientId, String id) throws FederationException {
        FederationClient client;
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Send back the loopup reply to the initial client");
        }
        if ((client = this.federationServer.getClient(initialClientId)) == null) {
            throw new FederationException("Can not find a valid client stub from clientID='" + initialClientId + "'");
        }
        try {
            this.federationServer.getClientManager().getClient(client.getCallbackURL()).lookupReply(endpoints, this.federationServer.getName(), id);
        }
        catch (FederationException e) {
            e.printStackTrace();
        }
    }

    private String getClientToInvoke(MessageExchange message, String clientId) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Client ID : " + clientId));
            logger.info((Object)("Message = " + message));
        }
        String result = null;
        if (message != null && message.getEndpoint() != null) {
            result = message.getEndpoint().getSubdomainLocation().substring(0, message.getEndpoint().getSubdomainLocation().indexOf(47));
        }
        return result;
    }
}

