/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.core.server;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.petalslink.dsb.federation.api.FederationException;
import org.petalslink.dsb.federation.core.api.FederationClient;
import org.petalslink.dsb.federation.core.api.FederationNode;
import org.petalslink.dsb.federation.core.server.FederationClientImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FederationNodeImpl
extends FederationClientImpl
implements FederationNode {
    private final Map<String, FederationClient> clients = new HashMap<String, FederationClient>();

    public FederationNodeImpl(String name, String callbackURL) {
        super(name, callbackURL, new Date());
    }

    @Override
    public void addClient(String name, String callbackURL) throws FederationException {
        if (name == null || callbackURL == null) {
            throw new FederationException("Name or/and callback is/are null : name='" + name + "', callbackURL='" + callbackURL + "'");
        }
        if (this.clients.get(name) != null) {
            throw new FederationException("The client '" + name + "' is already registered in the federation");
        }
        this.clients.put(name, new FederationClientImpl(name, callbackURL, new Date()));
    }

    @Override
    public Set<FederationClient> getClients() {
        return new HashSet<FederationClient>(this.clients.values());
    }

    @Override
    public void removeClient(String name) throws FederationException {
        if (name == null) {
            throw new FederationException("Client name can not be null");
        }
        this.clients.remove(name);
    }

    @Override
    public FederationClient getClient(String name) {
        return this.clients.get(name);
    }
}

