/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.core.server;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.api.EndpointQuery;
import org.petalslink.dsb.api.MessageExchange;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.federation.api.FederationException;
import org.petalslink.dsb.federation.core.api.ClientManager;
import org.petalslink.dsb.federation.core.api.FederationServer;
import org.petalslink.dsb.federation.core.api.PeerManager;
import org.petalslink.dsb.federation.core.api.PropagationStrategy;
import org.petalslink.dsb.federation.core.api.ServiceManager;
import org.petalslink.dsb.federation.core.server.FederationNodeImpl;
import org.petalslink.dsb.federation.core.server.ServiceManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FederationServerImpl
extends FederationNodeImpl
implements FederationServer {
    private ClientManager clientManager;
    private PropagationStrategy propagationStrategy;
    private ServiceManager serviceManager;
    private PeerManager peerManager;
    private static Log logger = LogFactory.getLog(FederationServerImpl.class);
    private boolean started;

    public FederationServerImpl(String name, String callBackURL) {
        super(name, callBackURL);
        this.setServiceManager(new ServiceManagerImpl());
    }

    @Override
    public void start() {
        if (this.getClientManager() == null) {
            throw new RuntimeException("The client manager can not be null");
        }
        if (this.getPropagationStrategy() == null) {
            throw new RuntimeException("The propagation strategy can not be null");
        }
        if (this.getServiceManager() != null) {
            this.serviceManager.start();
        }
        this.started = true;
    }

    @Override
    public void stop() {
        if (this.getServiceManager() != null) {
            this.serviceManager.stop();
        }
    }

    @Override
    public ClientManager getClientManager() {
        return this.clientManager;
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void invoke(MessageExchange message, String clientId, String id) throws FederationException {
        this.checkStarted();
        this.checkClient(clientId);
        this.getPropagationStrategy().invoke(message, clientId, id);
    }

    public void lookup(EndpointQuery query, String clientId, String id) throws FederationException {
        this.checkStarted();
        this.checkClient(clientId);
        this.propagationStrategy.lookup(query, clientId, id);
    }

    protected void checkClient(String clientId) throws FederationException {
        if (this.getClient(clientId) == null) {
            throw new FederationException("The client '" + clientId + "' is not a registered client within the federation");
        }
    }

    protected void checkStarted() {
        if (!this.started) {
            throw new RuntimeException("The server is not started");
        }
    }

    @Override
    public PropagationStrategy getPropagationStrategy() {
        return this.propagationStrategy;
    }

    @Override
    public void setClientManager(ClientManager clientManager) {
        this.clientManager = clientManager;
    }

    @Override
    public void setPropagationStrategy(PropagationStrategy propagationStrategy) {
        this.propagationStrategy = propagationStrategy;
    }

    @Override
    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public void lookupReply(Set<ServiceEndpoint> endpoints, String clientId, String id) throws FederationException {
        this.checkStarted();
        this.checkClient(clientId);
        this.getPropagationStrategy().lookupReply(endpoints, clientId, id);
    }

    @Override
    public PeerManager getPeerManager() {
        return this.peerManager;
    }

    @Override
    public void setPeerManager(PeerManager peerManager) {
        this.peerManager = peerManager;
    }
}

