/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.core.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.federation.core.api.Service;
import org.petalslink.dsb.federation.core.api.ServiceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagerImpl
implements ServiceManager {
    private final Map<String, Service> services = new ConcurrentHashMap<String, Service>();
    private static Log logger = LogFactory.getLog(ServiceManagerImpl.class);

    @Override
    public Service getService(String name) {
        return this.services.get(name);
    }

    @Override
    public List<Service> getServices() {
        return new ArrayList<Service>(this.services.values());
    }

    @Override
    public void start() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting internal services");
        }
        PriorityQueue<Service> queue = new PriorityQueue<Service>(this.services.size(), new Comparator());
        for (String name : this.services.keySet()) {
            if (this.services.get(name) == null || this.services.get(name).getType() != Service.TYPE.INTERNAL) continue;
            queue.add(this.services.get(name));
        }
        Service s = null;
        while ((s = queue.poll()) != null) {
            this.start(s.getName());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting *bound services");
        }
        queue = new PriorityQueue<Service>(this.services.size(), new Comparator());
        for (String name : this.services.keySet()) {
            if (this.services.get(name) == null || this.services.get(name).getType() == Service.TYPE.INTERNAL) continue;
            queue.add(this.services.get(name));
        }
        while ((s = queue.poll()) != null) {
            this.start(s.getName());
        }
    }

    @Override
    public void start(String serviceName) {
        Service s = this.services.get(serviceName);
        if (s != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Starting " + (Object)((Object)s.getType()) + " service " + s.getName() + " with priority " + s.getPriority()));
            }
            s.start();
        }
    }

    @Override
    public void stop() {
        for (String name : this.services.keySet()) {
            this.stop(name);
        }
    }

    @Override
    public void stop(String serviceName) {
        Service s = this.services.get(serviceName);
        if (s != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Stopping service " + s.getName()));
            }
            s.stop();
        }
    }

    @Override
    public void addService(Service service) {
        if (service != null && service.getName() != null && this.services.get(service.getName()) == null) {
            this.services.put(service.getName(), service);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Comparator
    implements java.util.Comparator<Service> {
        Comparator() {
        }

        @Override
        public int compare(Service s1, Service s2) {
            int result = 0;
            result = s1.getPriority() < s2.getPriority() ? 1 : (s1.getPriority() == s2.getPriority() ? 0 : -1);
            return result;
        }
    }
}

