/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.xmpp.client;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.federation.api.FederationService;
import org.petalslink.dsb.federation.core.client.ServiceManager;
import org.petalslink.dsb.federation.xmpp.client.FederationClientListener;
import org.petalslink.dsb.federation.xmpp.commons.OperationFilter;
import org.petalslink.dsb.federation.xmpp.commons.XMPPConnectionManager;

public class XMPPServiceManagerImpl
implements ServiceManager {
    private final String user;
    private final String password;
    private static Log logger = LogFactory.getLog(XMPPServiceManagerImpl.class);

    public XMPPServiceManagerImpl(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public void expose(String baseURL, FederationService federationService) {
        XMPPConnectionManager manager = XMPPConnectionManager.getInstance();
        boolean connected = manager.connect();
        if (connected) {
            manager.login(this.user, this.password);
            manager.addPacketListener(new FederationClientListener(federationService), new OperationFilter(FederationService.class));
        }
    }

    public void stop() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Service manager is stopping");
        }
        XMPPConnectionManager manager = XMPPConnectionManager.getInstance();
        manager.disconnect();
    }
}

