/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.xmpp.commons;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.smack.packet.Message;
import org.petalslink.dsb.api.EndpointQuery;
import org.petalslink.dsb.api.MessageExchange;
import org.petalslink.dsb.api.MessageExchangeException;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.api.util.JAXBEndpointQueryBuilder;
import org.petalslink.dsb.api.util.JAXBMessageExchangeBuilder;
import org.petalslink.dsb.federation.xmpp.commons.util.JAXBServiceEndpointCollectionHelper;
import org.petalslink.dsb.federation.xmpp.commons.util.ServiceEndpointCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Adapter {
    private Adapter() {
    }

    public static Message createMessage(MessageExchange exchange, String clientId, String id) {
        Message message = new Message();
        message.setBody(Adapter.toString(exchange));
        Adapter.setClientId(message, clientId);
        Adapter.setMessageId(message, id);
        return message;
    }

    public static Message createMessage(Set<ServiceEndpoint> endpoints, String clientId, String id) {
        Message message = new Message();
        message.setBody(Adapter.toString(endpoints));
        Adapter.setClientId(message, clientId);
        Adapter.setMessageId(message, id);
        return message;
    }

    private static void setMessageId(Message message, String id) {
        message.setProperty("fedmessageid", (Object)id);
    }

    private static String toString(Set<ServiceEndpoint> endpoints) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ServiceEndpointCollection collection = new ServiceEndpointCollection();
        collection.setEndpoints(endpoints.toArray(new ServiceEndpoint[endpoints.size()]));
        try {
            JAXBServiceEndpointCollectionHelper.marshall(collection, bos);
        }
        catch (MessageExchangeException e) {
            e.printStackTrace();
        }
        return bos.toString();
    }

    public static Message createMessage(EndpointQuery query, String clientId, String id) {
        Message message = new Message();
        message.setBody(Adapter.toString(query));
        Adapter.setClientId(message, clientId);
        Adapter.setMessageId(message, id);
        return message;
    }

    private static String toString(EndpointQuery query) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            JAXBEndpointQueryBuilder.marshall((EndpointQuery)query, (OutputStream)bos);
        }
        catch (MessageExchangeException e) {
            e.printStackTrace();
        }
        return bos.toString();
    }

    public static String getAction(Message message) {
        return message.getProperty("action").toString();
    }

    public static MessageExchange getMessageExchange(Message message) {
        return Adapter.messageExchangeFromString(message.getBody());
    }

    public static EndpointQuery getQuery(Message message) {
        return Adapter.endpointQueryFromString(message.getBody());
    }

    public static String getCallbackURL(Message message) {
        return message.getProperty("callbackurl").toString();
    }

    public static void setCallBackURL(Message message, String callbackURL) {
        message.setProperty("callbackurl", (Object)callbackURL);
    }

    public static void setAction(Message message, String action) {
        message.setProperty("action", (Object)action);
    }

    public static String getClientId(Message message) {
        return message.getProperty("clientid").toString();
    }

    public static void setClientId(Message message, String clientId) {
        message.setProperty("clientid", (Object)clientId);
    }

    private static String toString(MessageExchange messageExchange) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            JAXBMessageExchangeBuilder.marshall((MessageExchange)messageExchange, (OutputStream)bos);
        }
        catch (MessageExchangeException e) {
            e.printStackTrace();
        }
        return bos.toString();
    }

    private static MessageExchange messageExchangeFromString(String s) {
        try {
            return JAXBMessageExchangeBuilder.unmarshall((InputStream)new ByteArrayInputStream(s.getBytes()));
        }
        catch (MessageExchangeException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static EndpointQuery endpointQueryFromString(String s) {
        try {
            return JAXBEndpointQueryBuilder.unmarshall((InputStream)new ByteArrayInputStream(s.getBytes()));
        }
        catch (MessageExchangeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Set<ServiceEndpoint> getServiceEndpoints(Message message) {
        return Adapter.endpointsFromString(message.getBody());
    }

    private static Set<ServiceEndpoint> endpointsFromString(String body) {
        HashSet<ServiceEndpoint> result = new HashSet<ServiceEndpoint>();
        try {
            ServiceEndpointCollection collection = JAXBServiceEndpointCollectionHelper.unmarshall(new ByteArrayInputStream(body.getBytes()));
            if (collection != null) {
                ServiceEndpoint[] serviceEndpointArray = collection.getEndpoints();
                int n = serviceEndpointArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceEndpoint serviceEndpoint = serviceEndpointArray[n2];
                    result.add(serviceEndpoint);
                    ++n2;
                }
            }
        }
        catch (MessageExchangeException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void setMode(Message message, String mode) {
        message.setProperty("messagemode", (Object)mode);
    }

    public static String getMode(Message m) {
        return m.getProperty("messagemode") != null ? m.getProperty("messagemode").toString() : null;
    }

    public static String getFedId(Message m) {
        return m.getProperty("fedmessageid") != null ? m.getProperty("fedmessageid").toString() : null;
    }
}

