/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.xmpp.commons;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;

public class XMPPConnectionManager {
    private static Log logger = LogFactory.getLog(XMPPConnectionManager.class);
    public static int AVAILABLE_STATUS = 1;
    public static int UNAVAILABLE_STATUS = 2;
    private static Map<Integer, Presence> PRESENCE = new HashMap<Integer, Presence>();
    private static XMPPConnectionManager SINGLETON;
    private XMPPConnection connection;

    static {
        PRESENCE.put(AVAILABLE_STATUS, new Presence(Presence.Type.available));
        PRESENCE.put(UNAVAILABLE_STATUS, new Presence(Presence.Type.unavailable));
    }

    public static synchronized XMPPConnectionManager getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new XMPPConnectionManager();
        }
        return SINGLETON;
    }

    private XMPPConnectionManager() {
    }

    public boolean connect() {
        boolean result = true;
        if (this.connection != null) {
            return result;
        }
        ConnectionConfiguration configuration = new ConnectionConfiguration("talk.google.com", 5222, "gmail.com");
        this.connection = new XMPPConnection(configuration);
        try {
            this.connection.connect();
            this.connection.addConnectionListener(new ConnectionListener(){

                public void reconnectionSuccessful() {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Reconnection successfull");
                    }
                }

                public void reconnectionFailed(Exception arg0) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Reconnection failed");
                        logger.info((Object)"Let's reconnect ourself (X max attemps)");
                    }
                }

                public void reconnectingIn(int arg0) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Reconnecting In");
                    }
                }

                public void connectionClosedOnError(Exception arg0) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Connection closed on error");
                    }
                }

                public void connectionClosed() {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Connection closed");
                    }
                }
            });
        }
        catch (XMPPException e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public void login(String user, String password) {
        if (this.connection != null && this.connection.isConnected()) {
            try {
                this.connection.login(user, password);
            }
            catch (XMPPException e) {
                e.printStackTrace();
            }
        } else {
            logger.warn((Object)"Not connected to server, can not login!");
        }
    }

    public void disconnect() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    public void send(Message message, String jid) {
        Chat chat = this.connection.getChatManager().createChat(jid, null);
        try {
            chat.sendMessage(message);
        }
        catch (XMPPException e) {
            e.printStackTrace();
        }
    }

    public XMPPConnection getConnection() {
        return this.connection;
    }

    public void setStatus(int status, String realStatus) {
        if (this.connection != null && this.connection.isConnected() && PRESENCE.get(status) != null) {
            Presence p = PRESENCE.get(status);
            p.setStatus(realStatus);
            this.getConnection().sendPacket((Packet)PRESENCE.get(status));
        }
    }

    public void addPacketListener(PacketListener xmppListener, PacketFilter packetFilter) {
        if (this.connection != null && this.connection.isConnected()) {
            this.getConnection().addPacketListener(xmppListener, packetFilter);
        } else {
            logger.warn((Object)"Can not add the listener when connection is not OK");
        }
    }
}

