/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.xmpp.commons;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.packet.Message;
import org.petalslink.dsb.api.EndpointQuery;
import org.petalslink.dsb.api.MessageExchange;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.federation.api.FederationException;
import org.petalslink.dsb.federation.api.FederationService;
import org.petalslink.dsb.federation.xmpp.commons.Adapter;
import org.petalslink.dsb.federation.xmpp.commons.XMPPConnectionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMPPFederationClientImpl
implements FederationService {
    private static Log logger = LogFactory.getLog(XMPPFederationClientImpl.class);
    private final String jid;

    public XMPPFederationClientImpl(String jid) {
        this.jid = jid;
    }

    public void invoke(MessageExchange exchange, String clientId, String id) throws FederationException {
        XMPPConnectionManager xmppConnectionManager = XMPPConnectionManager.getInstance();
        Message message = Adapter.createMessage(exchange, clientId, id);
        Adapter.setAction(message, "invoke");
        xmppConnectionManager.send(message, this.jid);
    }

    public void lookup(EndpointQuery query, String clientId, String id) throws FederationException {
        XMPPConnectionManager xmppConnectionManager = XMPPConnectionManager.getInstance();
        Message message = Adapter.createMessage(query, clientId, id);
        Adapter.setAction(message, "lookup");
        xmppConnectionManager.send(message, this.jid);
    }

    public void lookupReply(Set<ServiceEndpoint> endpoints, String clientId, String id) throws FederationException {
        XMPPConnectionManager xmppConnectionManager = XMPPConnectionManager.getInstance();
        Message message = Adapter.createMessage(endpoints, clientId, id);
        Adapter.setAction(message, "lookupReply");
        xmppConnectionManager.send(message, this.jid);
    }
}

