/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.xmpp.server;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.petalslink.dsb.federation.api.FederationException;
import org.petalslink.dsb.federation.api.FederationManagementService;
import org.petalslink.dsb.federation.xmpp.commons.Adapter;

public class FederationManagementServiceListener
implements PacketListener,
FederationManagementService {
    private final FederationManagementService managementService;
    private static Log logger = LogFactory.getLog(FederationManagementServiceListener.class);

    public FederationManagementServiceListener(FederationManagementService managementService, ExecutorService executorService) {
        this.managementService = managementService;
    }

    public void processPacket(Packet packet) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Got a packet in federation management listener");
        }
        Message message = (Message)packet;
        String action = Adapter.getAction(message);
        String clientId = Adapter.getClientId(message);
        if ("join".equals(action)) {
            try {
                this.join(clientId, Adapter.getCallbackURL(message));
            }
            catch (FederationException e) {
                e.printStackTrace();
            }
        } else if ("leave".equals(action)) {
            try {
                this.leave(clientId);
            }
            catch (FederationException e) {
                e.printStackTrace();
            }
        } else {
            logger.warn((Object)("Unknown action " + action));
        }
    }

    public void join(String clientId, String callbackURL) throws FederationException {
        this.managementService.join(clientId, callbackURL);
    }

    public void leave(String clientId) throws FederationException {
        this.managementService.leave(clientId);
    }
}

