/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.xmpp.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.federation.core.api.Service;
import org.petalslink.dsb.federation.xmpp.commons.XMPPConnectionManager;

public class XMPPConnectionService
implements Service {
    private static Log logger = LogFactory.getLog(XMPPConnectionService.class);
    private final String login;
    private final String password;

    public XMPPConnectionService(String login, String password) {
        this.login = login;
        this.password = password;
    }

    public String getName() {
        return "XMPPConnectionService";
    }

    public Service.TYPE getType() {
        return Service.TYPE.INTERNAL;
    }

    public void start() {
        XMPPConnectionManager xmppConnectionManager = XMPPConnectionManager.getInstance();
        xmppConnectionManager.connect();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Logging to XMPP server with user='" + this.login + "' and password='************'"));
        }
        xmppConnectionManager.login(this.login, this.password);
        xmppConnectionManager.setStatus(XMPPConnectionManager.AVAILABLE_STATUS, "Federation Ready");
    }

    public void stop() {
        XMPPConnectionManager.getInstance().setStatus(XMPPConnectionManager.UNAVAILABLE_STATUS, "Shutting down Federation...");
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Disconnecting from server");
        }
        XMPPConnectionManager.getInstance().disconnect();
    }

    public int getPriority() {
        return 100;
    }
}

