/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.xmpp.commons;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.petalslink.dsb.federation.xmpp.commons.Adapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationFilter
implements PacketFilter {
    Set<String> values = new HashSet<String>();
    private static Log logger = LogFactory.getLog(OperationFilter.class);

    public OperationFilter() {
    }

    public OperationFilter(String[] operations) {
        this();
        for (String string : operations) {
            this.values.add(string);
        }
    }

    public OperationFilter(Class<?> clazz) {
        this();
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Adding authorized operation " + method.getName()));
            }
            this.values.add(method.getName());
        }
    }

    public boolean accept(Packet packet) {
        if (!(packet instanceof Message)) {
            return false;
        }
        Message m = (Message)packet;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got a message in operation filter " + m.toXML()));
        }
        return m.getType().equals((Object)Message.Type.chat) && this.isValidOperation(m);
    }

    private boolean isValidOperation(Message message) {
        String action = Adapter.getAction(message);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Incoming operation is '" + action + "' and authorized are '" + this.values + "'"));
        }
        return action != null && this.values.contains(action);
    }

    public Set<String> getValues() {
        return this.values;
    }
}

