/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.xmpp.server;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.petalslink.dsb.api.EndpointQuery;
import org.petalslink.dsb.api.MessageExchange;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.federation.api.FederationException;
import org.petalslink.dsb.federation.api.FederationService;
import org.petalslink.dsb.federation.xmpp.commons.Adapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FederationServiceListener
implements PacketListener,
FederationService {
    private final FederationService federationService;
    private static Log logger = LogFactory.getLog(FederationServiceListener.class);

    public FederationServiceListener(FederationService service, ExecutorService executorService) {
        this.federationService = service;
    }

    public void processPacket(Packet packet) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Got a packet in fedetation service listener");
        }
        Message message = (Message)packet;
        String action = Adapter.getAction(message);
        String clientId = Adapter.getClientId(message);
        String id = Adapter.getFedId(message);
        if ("invoke".equals(action)) {
            try {
                this.invoke(Adapter.getMessageExchange(message), clientId, id);
            }
            catch (FederationException e) {
                e.printStackTrace();
            }
        } else if ("lookup".equals(action)) {
            try {
                this.lookup(Adapter.getQuery(message), clientId, id);
            }
            catch (FederationException e) {
                e.printStackTrace();
            }
        } else if ("lookupReply".equals(action)) {
            try {
                this.lookupReply(Adapter.getServiceEndpoints(message), clientId, id);
            }
            catch (FederationException e) {
                e.printStackTrace();
            }
        } else {
            logger.warn((Object)("Unknown action " + action));
        }
    }

    public void invoke(MessageExchange message, String clientId, String id) throws FederationException {
        this.federationService.invoke(message, clientId, id);
    }

    public void lookup(EndpointQuery query, String clientId, String id) throws FederationException {
        this.federationService.lookup(query, clientId, id);
    }

    public void lookupReply(Set<ServiceEndpoint> endpoints, String clientId, String id) throws FederationException {
        this.federationService.lookupReply(endpoints, clientId, id);
    }
}

