/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.xmpp.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.federation.api.FederationManagementService;
import org.petalslink.dsb.federation.api.FederationService;
import org.petalslink.dsb.federation.core.api.FederationServer;
import org.petalslink.dsb.federation.core.api.Service;
import org.petalslink.dsb.federation.core.server.FederationManagementServiceImpl;
import org.petalslink.dsb.federation.core.server.FederationServiceImpl;
import org.petalslink.dsb.federation.xmpp.commons.OperationFilter;
import org.petalslink.dsb.federation.xmpp.commons.XMPPConnectionManager;
import org.petalslink.dsb.federation.xmpp.server.FederationManagementServiceListener;
import org.petalslink.dsb.federation.xmpp.server.FederationServiceListener;

public class XMPPInboundServiceImpl
implements Service {
    private ExecutorService executorService;
    private final FederationManagementService managementService;
    private final FederationService federationService;
    private final FederationServer federationServer;
    private static Log logger = LogFactory.getLog(XMPPInboundServiceImpl.class);

    public XMPPInboundServiceImpl(FederationServer federationServer) {
        this.federationServer = federationServer;
        this.managementService = new FederationManagementServiceImpl(this.federationServer);
        this.federationService = new FederationServiceImpl(this.federationServer);
    }

    public void start() {
        this.executorService = Executors.newFixedThreadPool(5);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Connecting to XMPP server");
        }
        XMPPConnectionManager xmppConnectionManager = XMPPConnectionManager.getInstance();
        xmppConnectionManager.addPacketListener(new FederationServiceListener(this.federationService, this.executorService), new OperationFilter(FederationService.class));
        xmppConnectionManager.addPacketListener(new FederationManagementServiceListener(this.managementService, this.executorService), new OperationFilter(FederationManagementService.class));
    }

    public void stop() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Stopping executors");
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public String getName() {
        return "XMPPServiceInbound";
    }

    public Service.TYPE getType() {
        return Service.TYPE.INBOUND;
    }

    public int getPriority() {
        return 0;
    }
}

