/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.federation.xmppwebserver;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.petalslink.dsb.federation.core.api.ClientManager;
import org.petalslink.dsb.federation.core.api.FederationClient;
import org.petalslink.dsb.federation.core.api.FederationServer;
import org.petalslink.dsb.federation.core.api.PeerChecker;
import org.petalslink.dsb.federation.core.api.PropagationStrategy;
import org.petalslink.dsb.federation.core.api.Service;
import org.petalslink.dsb.federation.core.commons.ClientFactory;
import org.petalslink.dsb.federation.core.commons.ClientManagerImpl;
import org.petalslink.dsb.federation.core.server.DefaultPropagationStrategy;
import org.petalslink.dsb.federation.core.server.FederationServerImpl;
import org.petalslink.dsb.federation.core.server.RemoteCheckerServiceImpl;
import org.petalslink.dsb.federation.xmpp.commons.XMPPClientFactory;
import org.petalslink.dsb.federation.xmpp.commons.XMPPPeerChecker;
import org.petalslink.dsb.federation.xmpp.server.XMPPConnectionService;
import org.petalslink.dsb.federation.xmpp.server.XMPPInboundServiceImpl;
import org.petalslink.dsb.federation.xmpp.server.XMPPPeerService;

public class FederationXMPPBotServlet
extends HttpServlet {
    private FederationServer server = null;
    private static final long serialVersionUID = -8723698373945722435L;

    public void init() throws ServletException {
        this.log("Intilializing connection to server");
        this.startServer();
    }

    public void destroy() {
        this.stopServer();
    }

    private void startServer() {
        System.out.println("Starting server");
        String login = this.getServletContext().getInitParameter("federationLogin");
        String password = this.getServletContext().getInitParameter("federationPassword");
        System.out.println("Connecting with " + login + " / " + password);
        this.server = new FederationServerImpl("GtalklFedServer01", login);
        ClientManagerImpl clientManager = new ClientManagerImpl();
        clientManager.setClientFactory((ClientFactory)new XMPPClientFactory());
        this.server.setClientManager((ClientManager)clientManager);
        this.server.setPropagationStrategy((PropagationStrategy)new DefaultPropagationStrategy(this.server));
        XMPPConnectionService xmppConnectionService = new XMPPConnectionService(login, password);
        this.server.getServiceManager().addService((Service)xmppConnectionService);
        XMPPPeerService xmppPresenceService = new XMPPPeerService(this.server.getPeerManager());
        this.server.getServiceManager().addService((Service)xmppPresenceService);
        XMPPInboundServiceImpl xmppInboundService = new XMPPInboundServiceImpl(this.server);
        this.server.getServiceManager().addService((Service)xmppInboundService);
        RemoteCheckerServiceImpl xmppChecker = new RemoteCheckerServiceImpl(this.server, (PeerChecker)new XMPPPeerChecker(this.server));
        this.server.getServiceManager().addService((Service)xmppChecker);
        this.server.start();
    }

    private void stopServer() {
        System.out.println("Stopping server");
        if (this.server != null) {
            this.server.stop();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletOutputStream os = resp.getOutputStream();
        StringBuffer sb = new StringBuffer();
        sb.append("<html><body><h1>Federation Server</h1>");
        sb.append("<h2>Informations</h2>");
        sb.append("Started at " + this.server.getJoinDate());
        sb.append("<br><br>");
        sb.append("Callback URL : " + this.server.getCallbackURL());
        sb.append("<br><br>");
        sb.append("<h2>Current Clients</h2>");
        for (FederationClient client : this.server.getClients()) {
            sb.append(" - " + client.getName() + ", joined at " + client.getJoinDate());
        }
        sb.append("</body></html>");
        os.write(sb.toString().getBytes());
        os.flush();
    }
}

